/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string.regex;

import java.io.IOException;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.WildcardQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RegexMatch;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class WildcardLike
extends RegexMatch<WildcardPattern> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "WildcardLike", WildcardLike::new);
    public static final String NAME = "LIKE";

    @FunctionInfo(returnType={"boolean"}, description="Use `LIKE` to filter data based on string patterns using wildcards. `LIKE`\nusually acts on a field placed on the left-hand side of the operator, but it can\nalso act on a constant (literal) expression. The right-hand side of the operator\nrepresents the pattern.\n\nThe following wildcard characters are supported:\n\n* `*` matches zero or more characters.\n* `?` matches one character.", detailedDescription="Matching the exact characters `*` and `.` will require escaping.\nThe escape character is backslash `\\`. Since also backslash is a special character in string literals,\nit will require further escaping.\n\n<<load-esql-example, file=string tag=likeEscapingSingleQuotes>>\n\nTo reduce the overhead of escaping, we suggest using triple quotes strings `\"\"\"`\n\n<<load-esql-example, file=string tag=likeEscapingTripleQuotes>>\n\n```{applies_to}\nstack: ga 9.1\nserverless: ga\n```\nBoth a single pattern or a list of patterns are supported. If a list of patterns is provided,\nthe expression will return true if any of the patterns match.\n\n<<load-esql-example, file=where-like tag=likeListDocExample>>\n\nPatterns may be specified with REST query placeholders as well\n\n```esql\nFROM employees\n| WHERE first_name LIKE ?pattern\n| KEEP first_name, last_name\n```\n\n```{applies_to}\nstack: ga 9.3\n```\n", operator="LIKE", examples={@Example(file="docs", tag="like")})
    public WildcardLike(Source source, @Param(name="str", type={"keyword", "text"}, description="A literal expression.") Expression left, @Param(name="pattern", type={"keyword", "text"}, description="Pattern.") WildcardPattern pattern) {
        this(source, left, pattern, false);
    }

    public WildcardLike(Source source, Expression left, WildcardPattern pattern, boolean caseInsensitive) {
        super(source, left, pattern, caseInsensitive);
    }

    private WildcardLike(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), new WildcardPattern(in.readString()), WildcardLike.deserializeCaseInsensitivity(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeString(((WildcardPattern)this.pattern()).pattern());
        this.serializeCaseInsensitivity(out);
    }

    @Override
    public String name() {
        return NAME;
    }

    public String getWriteableName() {
        return WildcardLike.ENTRY.name;
    }

    protected NodeInfo<WildcardLike> info() {
        return NodeInfo.create((Node)this, WildcardLike::new, (Object)this.field(), (Object)((WildcardPattern)this.pattern()), (Object)this.caseInsensitive());
    }

    protected WildcardLike replaceChild(Expression newLeft) {
        return new WildcardLike(this.source(), newLeft, (WildcardPattern)this.pattern(), this.caseInsensitive());
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableAttribute(this.field()) ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        Expression expression;
        Expression field = this.field();
        LucenePushdownPredicates.checkIsPushableAttribute(field);
        if (field instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)field;
            expression = fa.exactAttribute();
        } else {
            expression = field;
        }
        return this.translateField(handler.nameOf(expression), pushdownPredicates.flags().stringLikeOnIndex());
    }

    private Query translateField(String targetFieldName, boolean forceStringMatch) {
        return new WildcardQuery(this.source(), targetFieldName, ((WildcardPattern)this.pattern()).asLuceneWildcard(), this.caseInsensitive(), forceStringMatch);
    }

    public Expression optimizeStringCasingWithInsensitiveRegexMatch(Expression unwrappedField, Predicate<String> matchesCaseFn) {
        if (!matchesCaseFn.test(((WildcardPattern)this.pattern()).pattern())) {
            return Literal.of((Expression)this, (Object)Boolean.FALSE);
        }
        return new WildcardLike(this.source(), unwrappedField, (WildcardPattern)this.pattern(), true);
    }
}

