/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble;

public final class RoundToDouble3Evaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RoundToDouble3Evaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final double p0;
    private final double p1;
    private final double p2;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RoundToDouble3Evaluator(Source source, EvalOperator.ExpressionEvaluator field, double p0, double p1, double p2, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock fieldBlock = (DoubleBlock)this.field.eval(page);){
            DoubleVector fieldVector = fieldBlock.asVector();
            if (fieldVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), fieldBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), fieldVector).asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.field.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock fieldBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                double field = fieldBlock.getDouble(fieldBlock.getFirstValueIndex(p));
                result.appendDouble(RoundToDouble.process(field, this.p0, this.p1, this.p2));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector fieldVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double field = fieldVector.getDouble(p);
                result.appendDouble(p, RoundToDouble.process(field, this.p0, this.p1, this.p2));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "RoundToDouble3Evaluator[field=" + String.valueOf(this.field) + ", p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.field);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final double p0;
        private final double p1;
        private final double p2;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, double p0, double p1, double p2) {
            this.source = source;
            this.field = field;
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
        }

        public RoundToDouble3Evaluator get(DriverContext context) {
            return new RoundToDouble3Evaluator(this.source, this.field.get(context), this.p0, this.p1, this.p2, context);
        }

        public String toString() {
            return "RoundToDouble3Evaluator[field=" + String.valueOf(this.field) + ", p0=" + this.p0 + ", p1=" + this.p1 + ", p2=" + this.p2 + "]";
        }
    }
}

