/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.histogram;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramScratch;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.HistogramPercentile;

public final class HistogramPercentileEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(HistogramPercentileEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator value;
    private final EvalOperator.ExpressionEvaluator percentile;
    private final DriverContext driverContext;
    private Warnings warnings;

    public HistogramPercentileEvaluator(Source source, EvalOperator.ExpressionEvaluator value, EvalOperator.ExpressionEvaluator percentile, DriverContext driverContext) {
        this.source = source;
        this.value = value;
        this.percentile = percentile;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (ExponentialHistogramBlock valueBlock = (ExponentialHistogramBlock)this.value.eval(page);){
            DoubleBlock doubleBlock;
            block12: {
                DoubleBlock percentileBlock = (DoubleBlock)this.percentile.eval(page);
                try {
                    doubleBlock = this.eval(page.getPositionCount(), valueBlock, percentileBlock);
                    if (percentileBlock == null) break block12;
                }
                catch (Throwable throwable) {
                    if (percentileBlock != null) {
                        try {
                            percentileBlock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                percentileBlock.close();
            }
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.value.baseRamBytesUsed();
        return baseRamBytesUsed += this.percentile.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, ExponentialHistogramBlock valueBlock, DoubleBlock percentileBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
            block15: for (int p = 0; p < positionCount; ++p) {
                switch (valueBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                switch (percentileBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block15;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block15;
                    }
                }
                ExponentialHistogram value = valueBlock.getExponentialHistogram(valueBlock.getFirstValueIndex(p), valueScratch);
                double percentile = percentileBlock.getDouble(percentileBlock.getFirstValueIndex(p));
                try {
                    HistogramPercentile.process(result, value, percentile);
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "HistogramPercentileEvaluator[value=" + String.valueOf(this.value) + ", percentile=" + String.valueOf(this.percentile) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.value, this.percentile});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final EvalOperator.ExpressionEvaluator.Factory percentile;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, EvalOperator.ExpressionEvaluator.Factory percentile) {
            this.source = source;
            this.value = value;
            this.percentile = percentile;
        }

        public HistogramPercentileEvaluator get(DriverContext context) {
            return new HistogramPercentileEvaluator(this.source, this.value.get(context), this.percentile.get(context), context);
        }

        public String toString() {
            return "HistogramPercentileEvaluator[value=" + String.valueOf(this.value) + ", percentile=" + String.valueOf(this.percentile) + "]";
        }
    }
}

