/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AllFirstBytesRefByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AllFirstDoubleByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AllFirstFloatByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AllFirstIntByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AllFirstLongByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class AllFirst
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "AllFirst", AllFirst::readFrom);
    private final Expression sort;

    @FunctionInfo(type=FunctionType.AGGREGATE, preview=true, returnType={"long", "integer", "double", "keyword"}, description="Calculates the earliest value of a field, and can operate on null values.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.DEVELOPMENT)}, examples={@Example(file="stats_all_first_all_last", tag="all_first")})
    public AllFirst(Source source, @Param(name="value", type={"long", "integer", "double", "keyword", "text"}, description="Values to return") Expression field, @Param(name="sort", type={"date", "date_nanos"}, description="Sort key") Expression sort) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, sort);
    }

    private AllFirst(Source source, Expression field, Expression filter, Expression window, Expression sort) {
        super(source, field, filter, window, List.of(sort));
        this.sort = sort;
    }

    private static AllFirst readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression filter = (Expression)in.readNamedWriteable(Expression.class);
        Expression window = AllFirst.readWindow(in);
        List params = in.readNamedWriteableCollectionAsList(Expression.class);
        Expression sort = (Expression)params.getFirst();
        return new AllFirst(source, field, filter, window, sort);
    }

    public String getWriteableName() {
        return AllFirst.ENTRY.name;
    }

    protected NodeInfo<AllFirst> info() {
        return NodeInfo.create((Node)this, AllFirst::new, (Object)this.field(), (Object)this.sort);
    }

    public AllFirst replaceChildren(List<Expression> newChildren) {
        return new AllFirst(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public AllFirst withFilter(Expression filter) {
        return new AllFirst(this.source(), this.field(), filter, this.window(), this.sort);
    }

    public Expression sort() {
        return this.sort;
    }

    public DataType dataType() {
        return this.field().dataType().noText();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.BOOLEAN || dt == DataType.DATETIME || DataType.isString((DataType)dt) || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"boolean", "date", "ip", "string", "numeric except unsigned_long or counter types"}).and(TypeResolutions.isType((Expression)this.sort, dt -> dt == DataType.LONG || dt == DataType.DATETIME || dt == DataType.DATE_NANOS, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"long or date_nanos or datetime"}));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.LONG -> new AllFirstLongByTimestampAggregatorFunctionSupplier();
            case DataType.INTEGER -> new AllFirstIntByTimestampAggregatorFunctionSupplier();
            case DataType.DOUBLE -> new AllFirstDoubleByTimestampAggregatorFunctionSupplier();
            case DataType.FLOAT -> new AllFirstFloatByTimestampAggregatorFunctionSupplier();
            case DataType.KEYWORD, DataType.TEXT -> new AllFirstBytesRefByTimestampAggregatorFunctionSupplier();
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    public String toString() {
        return "all_first(" + String.valueOf(this.field()) + ", " + String.valueOf(this.sort) + ")";
    }
}

