/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianPointDocValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentCartesianPointDocValuesAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("minX", ElementType.INT), new IntermediateStateDesc("maxX", ElementType.INT), new IntermediateStateDesc("maxY", ElementType.INT), new IntermediateStateDesc("minY", ElementType.INT));
    private final DriverContext driverContext;
    private final SpatialExtentState state;
    private final List<Integer> channels;

    public SpatialExtentCartesianPointDocValuesAggregatorFunction(DriverContext driverContext, List<Integer> channels, SpatialExtentState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SpatialExtentCartesianPointDocValuesAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SpatialExtentCartesianPointDocValuesAggregatorFunction(driverContext, channels, SpatialExtentCartesianPointDocValuesAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        LongBlock vBlock = (LongBlock)page.getBlock(this.channels.get(0));
        LongVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        LongBlock vBlock = (LongBlock)page.getBlock(this.channels.get(0));
        LongVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(LongVector vVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            long vValue = vVector.getLong(valuesPosition);
            SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, vValue);
        }
    }

    private void addRawVector(LongVector vVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            long vValue = vVector.getLong(valuesPosition);
            SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, vValue);
        }
    }

    private void addRawBlock(LongBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                long vValue = vBlock.getLong(vOffset);
                SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, vValue);
            }
        }
    }

    private void addRawBlock(LongBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                long vValue = vBlock.getLong(vOffset);
                SpatialExtentCartesianPointDocValuesAggregator.combine(this.state, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SpatialExtentCartesianPointDocValuesAggregatorFunction.intermediateStateDesc().size());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        assert (minX.getPositionCount() == 1);
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        assert (maxX.getPositionCount() == 1);
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        assert (maxY.getPositionCount() == 1);
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minY.getPositionCount() == 1);
        SpatialExtentCartesianPointDocValuesAggregator.combineIntermediate(this.state, minX.getInt(0), maxX.getInt(0), maxY.getInt(0), minY.getInt(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SpatialExtentCartesianPointDocValuesAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

