/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.AllLongDoubleState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class AllFirstDoubleByTimestampAggregator {
    public static String describe() {
        return "all_first_double_by_timestamp";
    }

    public static AllLongDoubleState initSingle(DriverContext driverContext) {
        return new AllLongDoubleState(0L, 0.0);
    }

    private static void first(AllLongDoubleState current, long timestamp, double value, boolean v2Seen) {
        current.seen(true);
        current.v1(timestamp);
        current.v2(v2Seen ? value : 0.0);
        current.v2Seen(v2Seen);
    }

    public static void combine(AllLongDoubleState current, int position, DoubleBlock value, LongBlock timestamp) {
        if (!current.seen()) {
            AllFirstDoubleByTimestampAggregator.first(current, timestamp.getLong(position), value.getDouble(position), !value.isNull(position));
            return;
        }
        long ts = timestamp.getLong(position);
        if (ts < current.v1()) {
            current.v1(ts);
            current.seen(true);
            if (!value.isNull(position)) {
                current.v2(value.getDouble(position));
                current.v2Seen(true);
            } else {
                current.v2Seen(false);
            }
        }
    }

    public static void combineIntermediate(AllLongDoubleState current, long timestamp, double value, boolean seen, boolean v2Seen) {
        if (seen) {
            if (current.seen()) {
                if (timestamp < current.v1()) {
                    current.v1(timestamp);
                    current.v2(value);
                    current.v2Seen(v2Seen);
                }
            } else {
                current.v1(timestamp);
                current.v2(value);
                current.seen(true);
                current.v2Seen(v2Seen);
            }
        }
    }

    public static Block evaluateFinal(AllLongDoubleState current, DriverContext ctx) {
        if (current.v2Seen()) {
            return ctx.blockFactory().newConstantDoubleBlockWith(current.v2(), 1);
        }
        return ctx.blockFactory().newConstantNullBlock(1);
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays());
    }

    public static void combine(GroupingState current, int groupId, int position, DoubleBlock value, LongBlock timestamp) {
        boolean hasValue = !value.isNull(position);
        current.collectValue(groupId, timestamp.getLong(position), value.getDouble(position), hasValue);
    }

    public static void combineIntermediate(GroupingState current, int groupId, LongBlock timestamps, DoubleBlock values, BooleanBlock hasValues, int otherPosition) {
        int valueCount = values.getValueCount(otherPosition);
        if (valueCount > 0) {
            long timestamp = timestamps.getLong(timestamps.getFirstValueIndex(otherPosition));
            int firstIndex = values.getFirstValueIndex(otherPosition);
            boolean hasValueFlag = hasValues.getBoolean(otherPosition);
            for (int i = 0; i < valueCount; ++i) {
                current.collectValue(groupId, timestamp, values.getDouble(firstIndex + i), hasValueFlag);
            }
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateFinal(selected, ctx);
    }

    public static final class GroupingState
    extends AbstractArrayState {
        private final BigArrays bigArrays;
        private LongArray timestamps;
        private DoubleArray values;
        private ByteArray hasValues;
        private int maxGroupId = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        GroupingState(BigArrays bigArrays) {
            super(bigArrays);
            this.bigArrays = bigArrays;
            boolean success = false;
            LongArray timestamps = null;
            ByteArray hasValues = null;
            try {
                this.timestamps = timestamps = bigArrays.newLongArray(1L, false);
                this.values = bigArrays.newDoubleArray(1L, false);
                this.hasValues = hasValues = bigArrays.newByteArray(1L, false);
                this.enableGroupIdTracking(new SeenGroupIds.Empty());
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{timestamps, this.values, hasValues, () -> super.close()});
                throw throwable;
            }
        }

        void collectValue(int groupId, long timestamp, double value, boolean hasVal) {
            boolean updated = false;
            if ((long)groupId < this.timestamps.size()) {
                if (groupId > this.maxGroupId || !this.hasValue(groupId) || this.timestamps.get((long)groupId) > timestamp) {
                    this.timestamps.set((long)groupId, timestamp);
                    updated = true;
                }
            } else {
                this.timestamps = this.bigArrays.grow(this.timestamps, (long)(groupId + 1));
                this.timestamps.set((long)groupId, timestamp);
                updated = true;
            }
            if (updated) {
                this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
                this.values.set((long)groupId, value);
                this.hasValues = this.bigArrays.grow(this.hasValues, (long)(groupId + 1));
                this.hasValues.set((long)groupId, (byte)(hasVal ? 1 : 0));
            }
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
            this.trackGroupId(groupId);
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.timestamps, this.values, this.hasValues, () -> super.close()});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            try (LongBlock.Builder timestampsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 DoubleBlock.Builder valuesBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
                 BooleanBlock.Builder hasValuesBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValues.get((long)group) == 1) {
                        timestampsBuilder.appendLong(this.timestamps.get((long)group));
                        valuesBuilder.appendDouble(this.values.get((long)group));
                        hasValuesBuilder.appendBoolean(true);
                        continue;
                    }
                    timestampsBuilder.appendNull();
                    valuesBuilder.appendNull();
                    hasValuesBuilder.appendBoolean(false);
                }
                blocks[offset] = timestampsBuilder.build();
                blocks[offset + 1] = valuesBuilder.build();
                blocks[offset + 2] = hasValuesBuilder.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            try (DoubleBlock.Builder builder = evalContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValues.get((long)group) == 1) {
                        builder.appendDouble(this.values.get((long)group));
                        continue;
                    }
                    builder.appendNull();
                }
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }
    }
}

