/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;

public class DropConstraintConstantAction
extends ConstraintConstantAction {
    private boolean cascade;
    private String constraintSchemaName;
    private int verifyType;

    DropConstraintConstantAction(String constraintName, String constraintSchemaName, String tableName, UUID tableId, String tableSchemaName, IndexConstantAction indexAction, int behavior, int verifyType) {
        super(constraintName, 5, tableName, tableId, tableSchemaName, indexAction);
        this.cascade = behavior == 0;
        this.constraintSchemaName = constraintSchemaName;
        this.verifyType = verifyType;
    }

    public String toString() {
        if (this.constraintName == null) {
            return "DROP PRIMARY KEY";
        }
        String ss = this.constraintSchemaName == null ? this.schemaName : this.constraintSchemaName;
        return "DROP CONSTRAINT " + ss + "." + this.constraintName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        boolean cascadeOnRefKey;
        ConstraintDescriptor conDesc = null;
        Object indexId = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableName});
        }
        SchemaDescriptor tdSd = td.getSchemaDescriptor();
        SchemaDescriptor constraintSd = this.constraintSchemaName == null ? tdSd : dd.getSchemaDescriptor(this.constraintSchemaName, tc, true);
        conDesc = this.constraintName == null ? dd.getConstraintDescriptors(td).getPrimaryKey() : dd.getConstraintDescriptorByName(td, constraintSd, this.constraintName, true);
        if (conDesc == null) {
            String errorName = this.constraintName == null ? "PRIMARY KEY" : constraintSd.getSchemaName() + "." + this.constraintName;
            throw StandardException.newException((String)"42X86", (Object[])new Object[]{errorName, td.getQualifiedName()});
        }
        switch (this.verifyType) {
            case 3: {
                if (conDesc.getConstraintType() == this.verifyType) break;
                throw StandardException.newException((String)"42Z9E", (Object[])new Object[]{this.constraintName, "UNIQUE"});
            }
            case 4: {
                if (conDesc.getConstraintType() == this.verifyType) break;
                throw StandardException.newException((String)"42Z9E", (Object[])new Object[]{this.constraintName, "CHECK"});
            }
            case 6: {
                if (conDesc.getConstraintType() == this.verifyType) break;
                throw StandardException.newException((String)"42Z9E", (Object[])new Object[]{this.constraintName, "FOREIGN KEY"});
            }
        }
        boolean bl = cascadeOnRefKey = this.cascade && conDesc instanceof ReferencedKeyConstraintDescriptor;
        if (!cascadeOnRefKey) {
            dm.invalidateFor(conDesc, 19, lcc);
        }
        this.dropConstraint(conDesc, activation, lcc, !cascadeOnRefKey);
        if (cascadeOnRefKey) {
            ReferencedKeyConstraintDescriptor cd = (ReferencedKeyConstraintDescriptor)conDesc;
            ConstraintDescriptorList cdl = cd.getForeignKeyConstraints(3);
            int cdlSize = cdl.size();
            for (int index = 0; index < cdlSize; ++index) {
                ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cdl.elementAt(index);
                dm.invalidateFor(fkcd, 19, lcc);
                this.dropConstraint(fkcd, activation, lcc, true);
            }
            dm.invalidateFor(conDesc, 19, lcc);
            dm.clearDependencies(lcc, conDesc);
        }
    }
}

