"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDownloadOptions = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/share-plugin/public");
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/utils/table_inspector_view/components/download_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const detectFormulasInTables = (0, _lodash.memoize)(datatables => datatables.some(({
  columns,
  rows
}) => (0, _common.tableHasFormulas)(columns, rows)));
class DataDownloadOptions extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onTogglePopover", () => {
      this.setState(state => ({
        isPopoverOpen: !state.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "exportCsv", (isFormatted = true) => {
      let filename = this.props.title;
      if (!filename || filename.length === 0) {
        filename = _i18n.i18n.translate('data.inspector.table.downloadOptionsUnsavedFilename', {
          defaultMessage: 'unsaved'
        });
      }
      const content = this.props.datatables.reduce((memo, datatable, i) => {
        // skip empty datatables
        if (datatable) {
          const postFix = this.props.datatables.length > 1 ? `-${i + 1}` : '';
          memo[`${filename}${postFix}.csv`] = {
            content: (0, _common.datatableToCSV)(datatable, {
              csvSeparator: this.props.uiSettings.get('csv:separator', ','),
              quoteValues: this.props.uiSettings.get('csv:quoteValues', true),
              raw: !isFormatted,
              formatFactory: this.props.fieldFormats.deserialize,
              escapeFormulaValues: false
            }),
            type: _common.CSV_MIME_TYPE
          };
        }
        return memo;
      }, {});
      if (content) {
        (0, _public.downloadMultipleAs)(content);
      }
    });
    (0, _defineProperty2.default)(this, "exportFormattedCsv", () => {
      this.exportCsv(true);
    });
    (0, _defineProperty2.default)(this, "exportFormattedAsRawCsv", () => {
      this.exportCsv(false);
    });
  }
  renderFormattedDownloads() {
    const detectedFormulasInTables = detectFormulasInTables(this.props.datatables);
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      size: "s",
      onClick: this.onTogglePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.downloadCSVToggleButtonLabel",
      defaultMessage: "Download CSV",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }));
    const downloadButton = detectedFormulasInTables ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('data.inspector.table.exportButtonFormulasWarning', {
        defaultMessage: 'Your CSV contains characters that spreadsheet applications might interpret as formulas.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, button) : button;
    const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "csv",
      onClick: this.exportFormattedCsv,
      toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.formattedCSVButtonTooltip",
        defaultMessage: "Download the data in table format",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }),
      toolTipProps: {
        position: 'left'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.formattedCSVButtonLabel",
      defaultMessage: "Formatted CSV",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "rawCsv",
      onClick: this.exportFormattedAsRawCsv,
      toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.rawCSVButtonTooltip",
        defaultMessage: "Download the data as provided, for example, dates as timestamps",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 11
        }
      }),
      toolTipProps: {
        position: 'left'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.rawCSVButtonLabel",
      defaultMessage: "Raw CSV",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }))];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "inspectorDownloadData",
      button: downloadButton,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      className: "eui-textNoWrap",
      items: items,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }));
  }
  render() {
    return this.renderFormattedDownloads();
  }
}
exports.DataDownloadOptions = DataDownloadOptions;
(0, _defineProperty2.default)(DataDownloadOptions, "propTypes", {
  title: _propTypes.default.string.isRequired,
  uiSettings: _propTypes.default.object.isRequired,
  datatables: _propTypes.default.array,
  fieldFormats: _propTypes.default.object.isRequired
});