"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSessionsMgmtTable = SearchSessionsMgmtTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _ = require("..");
var _common = require("../../../../../../common");
var _get_columns = require("./columns/get_columns");
var _get_app_filter = require("./utils/get_app_filter");
var _get_status_filter = require("./utils/get_status_filter");
var _map_to_ui_session = require("./utils/map_to_ui_session");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SearchSessionsMgmtTable({
  core,
  locators,
  api,
  timezone,
  config,
  searchSessionEBTManager,
  kibanaVersion,
  searchUsageCollector,
  hideRefreshButton = false,
  getColumns = _get_columns.getColumns,
  appId,
  onBackgroundSearchOpened,
  trackingProps,
  ...props
}) {
  const [tableData, setTableData] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [debouncedIsLoading, setDebouncedIsLoading] = (0, _react.useState)(false);
  const showLatestResultsHandler = (0, _react.useRef)();
  const refreshTimeoutRef = (0, _react.useRef)(null);
  const refreshInterval = (0, _react.useMemo)(() => _moment.default.duration(config.management.refreshInterval).asMilliseconds(), [config.management.refreshInterval]);
  const enableOpeningInNewTab = (0, _react.useMemo)(() => core.featureFlags.getBooleanValue('discover.tabsEnabled', true), [core.featureFlags]);
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'searchSessionsMgmt',
    initialSort: {
      field: 'created',
      direction: 'desc'
    }
  });

  // Debounce rendering the state of the Refresh button
  (0, _useDebounce.default)(() => {
    setDebouncedIsLoading(isLoading);
  }, 250, [isLoading]);
  (0, _react.useEffect)(() => {
    searchSessionEBTManager.trackBgsListView({
      entryPoint: trackingProps.openedFrom
    });
  }, [searchSessionEBTManager, trackingProps.openedFrom]);

  // refresh behavior
  const doRefresh = (0, _react.useCallback)(async () => {
    if (refreshTimeoutRef.current) {
      clearTimeout(refreshTimeoutRef.current);
      refreshTimeoutRef.current = null;
    }
    setIsLoading(true);
    const renderResults = results => {
      setTableData(results);
    };
    showLatestResultsHandler.current = renderResults;
    if (document.visibilityState !== 'hidden') {
      let results = [];
      try {
        const {
          savedObjects,
          statuses
        } = await api.fetchTableData({
          appId
        });
        results = savedObjects.map(savedObject => (0, _map_to_ui_session.mapToUISession)({
          savedObject,
          locators,
          sessionStatuses: statuses,
          enableOpeningInNewTab
        }));
      } catch (e) {} // eslint-disable-line no-empty

      if (showLatestResultsHandler.current === renderResults) {
        renderResults(results);
        setIsLoading(false);
      }
    }
    if (showLatestResultsHandler.current === renderResults && refreshInterval > 0) {
      if (refreshTimeoutRef.current) clearTimeout(refreshTimeoutRef.current);
      refreshTimeoutRef.current = window.setTimeout(doRefresh, refreshInterval);
    }
  }, [api, refreshInterval, locators, appId, enableOpeningInNewTab]);

  // initial data load
  (0, _react.useEffect)(() => {
    doRefresh();
    searchUsageCollector.trackSessionsListLoaded();
    return () => {
      if (refreshTimeoutRef.current) clearTimeout(refreshTimeoutRef.current);
    };
  }, [doRefresh, searchUsageCollector]);
  const onActionComplete = () => {
    doRefresh();
  };
  const columns = getColumns({
    core,
    api,
    config,
    timezone,
    onActionComplete,
    kibanaVersion,
    searchUsageCollector,
    onBackgroundSearchOpened: attrs => {
      searchSessionEBTManager.trackBgsOpened({
        session: attrs.session,
        resumeSource: trackingProps.renderedIn
      });
      onBackgroundSearchOpened === null || onBackgroundSearchOpened === void 0 ? void 0 : onBackgroundSearchOpened(attrs);
    }
  });
  const filters = (0, _react.useMemo)(() => {
    const _filters = [];
    const hasAppColumn = columns.some(column => 'field' in column && column.field === 'appId');
    if (hasAppColumn && !appId) _filters.push((0, _get_app_filter.getAppFilter)(tableData));
    const hasStatusColumn = columns.some(column => 'field' in column && column.field === 'status');
    if (hasStatusColumn) _filters.push((0, _get_status_filter.getStatusFilter)(tableData));
    return _filters;
  }, [columns, tableData, appId]);

  // table config: search / filters
  const search = {
    box: {
      incremental: true
    },
    filters,
    toolsRight: hideRefreshButton ? undefined : /*#__PURE__*/_react.default.createElement(_.TableText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "refresh",
      onClick: doRefresh,
      disabled: debouncedIsLoading,
      isLoading: debouncedIsLoading,
      "data-test-subj": "sessionManagementRefreshBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.mgmt.searchSessions.search.tools.refresh",
      defaultMessage: "Refresh",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    })))
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({}, props, {
    id: _common.SEARCH_SESSIONS_TABLE_ID,
    "data-test-subj": _common.SEARCH_SESSIONS_TABLE_ID,
    rowProps: searchSession => ({
      'data-test-subj': `searchSessionsRow`,
      'data-test-search-session-id': `id-${searchSession.id}`
    }),
    columns: columns,
    items: tableData,
    pagination: {
      pageSize
    },
    search: search,
    sorting: sorting,
    onTableChange: onTableChange,
    tableLayout: "auto",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 5
    }
  }));
}