"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceDefinition = getServiceDefinition;
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getServiceDefinition() {
  return {
    get: {
      out: {
        result: {
          schema: (0, _schema.getDashboardGetResultSchema)()
        }
      }
    },
    update: {
      in: {
        options: {
          schema: _schema.dashboardUpdateOptionsSchema
        },
        data: {
          schema: (0, _schema.getDashboardUpdateRequestAttributesSchema)()
        }
      }
    }
  };
}