"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateRequestBody = getCreateRequestBody;
exports.getCreateResponseBody = getCreateResponseBody;
var _configSchema = require("@kbn/config-schema");
var _schema = require("../../content_management/v1/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getCreateRequestBody() {
  return _configSchema.schema.object({
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    data: (0, _schema.getDashboardDataSchema)(),
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1,
      maxSize: 1
    }))
  });
}
function getCreateResponseBody() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    data: (0, _schema.getDashboardDataSchema)(),
    meta: _schema.dashboardMetaSchema,
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  });
}