"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findService = void 0;
var _std = require("@kbn/std");
var _common = require("@kbn/kibana-utils-plugin/common");
var _dashboard_client = require("./dashboard_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const findService = exports.findService = {
  findById: async id => {
    try {
      var _result$data$referenc;
      const result = await _dashboard_client.dashboardClient.get(id);
      return {
        id,
        status: 'success',
        attributes: result.data,
        references: (_result$data$referenc = result.data.references) !== null && _result$data$referenc !== void 0 ? _result$data$referenc : []
      };
    } catch (error) {
      return {
        id,
        status: 'error',
        notFound: error instanceof _common.SavedObjectNotFound,
        error
      };
    }
  },
  findByIds: async ids => {
    return (0, _std.asyncMap)(ids, async id => {
      return findService.findById(id);
    });
  },
  findByTitle: async title => {
    const {
      dashboards
    } = await _dashboard_client.dashboardClient.search({
      search: title,
      per_page: 10
    });

    // The search isn't an exact match, lets see if we can find a single exact match to use
    const matchingDashboards = dashboards.filter(dashboard => dashboard.data.title.toLowerCase() === title.toLowerCase());
    if (matchingDashboards.length === 1) {
      return {
        id: matchingDashboards[0].id
      };
    }
  },
  search: _dashboard_client.dashboardClient.search
};