"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LATEST_VERSION = exports.DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_HEIGHT = exports.DEFAULT_DASHBOARD_OPTIONS = exports.DASHBOARD_GRID_COLUMN_COUNT = exports.DASHBOARD_API_VERSION = exports.CONTENT_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LATEST_VERSION = exports.LATEST_VERSION = 1;
const DASHBOARD_API_VERSION = exports.DASHBOARD_API_VERSION = String(LATEST_VERSION);
const CONTENT_ID = exports.CONTENT_ID = 'dashboard';
const DASHBOARD_GRID_COLUMN_COUNT = exports.DASHBOARD_GRID_COLUMN_COUNT = 48;
const DEFAULT_PANEL_WIDTH = exports.DEFAULT_PANEL_WIDTH = DASHBOARD_GRID_COLUMN_COUNT / 2;
const DEFAULT_PANEL_HEIGHT = exports.DEFAULT_PANEL_HEIGHT = 15;
const DEFAULT_DASHBOARD_OPTIONS = exports.DEFAULT_DASHBOARD_OPTIONS = {
  hidePanelTitles: false,
  useMargins: true,
  syncColors: false,
  syncCursor: true,
  syncTooltips: false
};