"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flyoutEditDrilldownAction = exports.OPEN_FLYOUT_EDIT_DRILLDOWN = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationUtil = require("@kbn/presentation-util");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/embeddable-enhanced-plugin/public");
var _i18n = require("./i18n");
var _menu_item = require("./menu_item");
var _drilldown_shared = require("../drilldown_shared");
var _kibana_services = require("../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dashboard_enhanced/public/services/drilldowns/actions/flyout_edit_drilldown/flyout_edit_drilldown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OPEN_FLYOUT_EDIT_DRILLDOWN = exports.OPEN_FLYOUT_EDIT_DRILLDOWN = 'OPEN_FLYOUT_EDIT_DRILLDOWN';
const isApiCompatible = api => (0, _public3.apiHasDynamicActions)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasSupportedTriggers)(api);
const flyoutEditDrilldownAction = exports.flyoutEditDrilldownAction = {
  id: OPEN_FLYOUT_EDIT_DRILLDOWN,
  type: OPEN_FLYOUT_EDIT_DRILLDOWN,
  order: 10,
  getIconType: () => 'list',
  grouping: [_drilldown_shared.DRILLDOWN_ACTION_GROUP],
  getDisplayName: () => _i18n.txtDisplayName,
  MenuItem: _menu_item.MenuItem,
  isCompatible: async ({
    embeddable
  }) => {
    var _embeddable$dynamicAc, _embeddable$dynamicAc2;
    if (!isApiCompatible(embeddable) || (0, _presentationPublishing.getInheritedViewMode)(embeddable) !== 'edit') return false;
    return ((_embeddable$dynamicAc = (_embeddable$dynamicAc2 = embeddable.dynamicActionsState$.getValue()) === null || _embeddable$dynamicAc2 === void 0 ? void 0 : _embeddable$dynamicAc2.dynamicActions.events) !== null && _embeddable$dynamicAc !== void 0 ? _embeddable$dynamicAc : []).length > 0;
  },
  execute: async ({
    embeddable
  }) => {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    (0, _presentationUtil.openLazyFlyout)({
      core: _kibana_services.coreServices,
      parentApi: embeddable.parentApi,
      loadContent: async ({
        closeFlyout
      }) => {
        const templates = (0, _drilldown_shared.createDrilldownTemplatesFromSiblings)(embeddable);
        return /*#__PURE__*/_react.default.createElement(_kibana_services.uiActionsEnhancedServices.DrilldownManager, {
          initialRoute: '/manage',
          dynamicActionManager: embeddable.enhancements.dynamicActions,
          triggers: [...(0, _drilldown_shared.ensureNestedTriggers)(embeddable.supportedTriggers()), _public2.CONTEXT_MENU_TRIGGER],
          placeContext: {
            embeddable
          },
          templates: templates,
          onClose: closeFlyout,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 11
          }
        });
      },
      flyoutProps: {
        'data-test-subj': 'editDrilldownFlyout',
        'aria-labelledby': 'drilldownFlyoutTitleAriaId',
        focusedPanelId: (0, _presentationPublishing.apiHasUniqueId)(embeddable) ? embeddable.uuid : undefined
      }
    });
  }
};