"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrossClusterReplicationPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
var _track_ui_metric = require("./app/services/track_ui_metric");
var _notifications = require("./app/services/notifications");
var _api = require("./app/services/api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // @ts-ignore;
class CrossClusterReplicationPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(coreSetup, plugins) {
    const {
      licensing,
      remoteClusters,
      usageCollection,
      management,
      indexManagement
    } = plugins;
    const esSection = management.sections.section.data;
    const {
      http,
      notifications: {
        toasts
      },
      fatalErrors,
      getStartServices
    } = coreSetup;

    // Initialize services even if the app isn't mounted, because they're used by index management extensions.
    (0, _api.setHttpClient)(http);
    (0, _track_ui_metric.init)(usageCollection);
    (0, _notifications.init)(toasts, fatalErrors);
    const ccrApp = esSection.registerApp({
      id: _constants.MANAGEMENT_ID,
      title: _constants.PLUGIN.TITLE,
      order: 6,
      mount: async ({
        element,
        setBreadcrumbs,
        history
      }) => {
        const {
          mountApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app')));
        const [coreStart] = await getStartServices();
        const {
          chrome: {
            docTitle
          },
          docLinks,
          application: {
            getUrlForApp
          },
          executionContext
        } = coreStart;
        docTitle.change(_constants.PLUGIN.TITLE);
        const unmountAppCallback = await mountApp({
          startServices: coreStart,
          element,
          setBreadcrumbs,
          docLinks,
          history,
          getUrlForApp,
          executionContext
        });
        return () => {
          docTitle.reset();
          unmountAppCallback();
        };
      }
    });

    // NOTE: We enable the plugin by default instead of disabling it by default because this
    // creates a race condition that causes functional tests to fail on CI (see #66781).
    Promise.all([(0, _rxjs.firstValueFrom)(licensing.license$), getStartServices()]).then(([license, startServices]) => {
      var _capabilities$managem;
      const licenseStatus = license.check(_constants.PLUGIN.ID, _constants.PLUGIN.minimumLicenseType);
      const isLicenseOk = licenseStatus.state === 'valid';
      const config = this.initializerContext.config.get();
      const capabilities = startServices[0].application.capabilities;

      // remoteClusters.isUiEnabled is driven by the xpack.remote_clusters.ui.enabled setting.
      // The CCR UI depends upon the Remote Clusters UI (e.g. by cross-linking to it), so if
      // the Remote Clusters UI is disabled we can't show the CCR UI.
      const isCcrUiEnabled = ((_capabilities$managem = capabilities.management.data) === null || _capabilities$managem === void 0 ? void 0 : _capabilities$managem[_constants.MANAGEMENT_ID]) && config.ui.enabled && remoteClusters.isUiEnabled;
      if (isLicenseOk && isCcrUiEnabled) {
        if (indexManagement) {
          const propertyPath = 'isFollowerIndex';
          const followerBadgeExtension = {
            matchIndex: index => {
              return (0, _lodash.get)(index, propertyPath);
            },
            label: _i18n.i18n.translate('xpack.crossClusterReplication.indexMgmtBadge.followerLabel', {
              defaultMessage: 'Follower'
            }),
            color: 'default',
            filterExpression: 'isFollowerIndex:true'
          };
          indexManagement.extensionsService.addBadge(followerBadgeExtension);
        }
      } else {
        ccrApp.disable();
      }
    });
  }
  start() {}
  stop() {}
}
exports.CrossClusterReplicationPlugin = CrossClusterReplicationPlugin;