"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _routing = require("../../../../../services/routing");
var _components = require("../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/home/follower_indices_list/components/context_menu/context_menu.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ContextMenu extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "editFollowerIndex", id => {
      const uri = _routing.routing.getFollowerIndexPath(id);
      _routing.routing.navigate(uri);
    });
  }
  render() {
    const {
      followerIndices,
      isPollingStatus = false
    } = this.props;
    const followerIndicesLength = followerIndices.length;
    const followerIndexNames = followerIndices.map(index => index.name);
    const {
      iconSide = 'right',
      iconType = 'arrowDown',
      anchorPosition = 'rightUp',
      label = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndex.contextMenu.buttonLabel",
        defaultMessage: "Manage follower {followerIndicesLength, plural, one {index} other {indices}}",
        values: {
          followerIndicesLength
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      }),
      testSubj
    } = this.props;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": testSubj,
      iconSide: iconSide,
      onClick: this.onButtonClick,
      iconType: iconType,
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, label);
    const pausedFollowerIndexNames = followerIndices.filter(({
      isPaused
    }) => isPaused).map(index => index.name);
    const activeFollowerIndices = followerIndices.filter(({
      isPaused
    }) => !isPaused);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: anchorPosition,
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.title",
      defaultMessage: "Follower {followerIndicesLength, plural, one {index} other {indices}} options",
      values: {
        followerIndicesLength
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      "data-test-subj": "contextMenu",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    }, activeFollowerIndices.length ? /*#__PURE__*/_react.default.createElement(_components.FollowerIndexPauseProvider, {
      onConfirm: this.closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 13
      }
    }, pauseFollowerIndex => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pause",
      onClick: () => pauseFollowerIndex(activeFollowerIndices),
      "data-test-subj": "pauseButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.pauseLabel",
      defaultMessage: "Pause replication",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 19
      }
    }))) : null, pausedFollowerIndexNames.length && !isPollingStatus ? /*#__PURE__*/_react.default.createElement(_components.FollowerIndexResumeProvider, {
      onConfirm: this.closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, resumeFollowerIndex => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "play",
      onClick: () => resumeFollowerIndex(pausedFollowerIndexNames),
      "data-test-subj": "resumeButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.resumeLabel",
      defaultMessage: "Resume replication",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 19
      }
    }))) : null, followerIndexNames.length === 1 && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pencil",
      onClick: () => this.editFollowerIndex(followerIndexNames[0]),
      "data-test-subj": "editButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.editLabel",
      "data-test-subj": "editButton",
      defaultMessage: "Edit follower index",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_components.FollowerIndexUnfollowProvider, {
      onConfirm: this.closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }, unfollowLeaderIndex => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "indexFlush",
      onClick: () => unfollowLeaderIndex(followerIndexNames),
      "data-test-subj": "unfollowButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.unfollowLabel",
      defaultMessage: "Unfollow leader {followerIndicesLength, plural, one {index} other {indices}}",
      values: {
        followerIndicesLength
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 17
      }
    })))));
  }
}
exports.ContextMenu = ContextMenu;
(0, _defineProperty2.default)(ContextMenu, "propTypes", {
  iconSide: _propTypes.default.string,
  iconType: _propTypes.default.string,
  anchorPosition: _propTypes.default.string,
  label: _propTypes.default.node,
  followerIndices: _propTypes.default.array.isRequired,
  isPollingStatus: _propTypes.default.bool
});