"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.adoptToHapiOnPostAuthFormat = adoptToHapiOnPostAuthFormat;
var _coreHttpServer = require("@kbn/core-http-server");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const postAuthResult = {
  next() {
    return {
      type: _coreHttpServer.OnPostAuthResultType.next
    };
  },
  isNext(result) {
    return result && result.type === _coreHttpServer.OnPostAuthResultType.next;
  },
  isAuthzResult(result) {
    return result && result.type === _coreHttpServer.OnPostAuthResultType.authzResult;
  }
};
const toolkit = {
  next: postAuthResult.next,
  authzResultNext: authzResult => {
    return {
      type: _coreHttpServer.OnPostAuthResultType.authzResult,
      authzResult
    };
  }
};

/**
 * Adopt custom request interceptor to Hapi lifecycle system.
 * @param fn - an extension point allowing to perform custom logic for
 * incoming HTTP requests.
 */
function adoptToHapiOnPostAuthFormat(fn, log) {
  return async function interceptRequest(request, responseToolkit) {
    const hapiResponseAdapter = new _coreHttpRouterServerInternal.HapiResponseAdapter(responseToolkit);
    try {
      const result = await fn(_coreHttpRouterServerInternal.CoreKibanaRequest.from(request), _coreHttpRouterServerInternal.lifecycleResponseFactory, toolkit);
      if ((0, _coreHttpServer.isKibanaResponse)(result)) {
        return hapiResponseAdapter.handle(result);
      }
      if (postAuthResult.isNext(result)) {
        return responseToolkit.continue;
      }
      if (postAuthResult.isAuthzResult(result)) {
        Object.defineProperty(request.app, 'authzResult', {
          value: (0, _std.deepFreeze)(result.authzResult),
          configurable: false,
          writable: false,
          enumerable: false
        });
        return responseToolkit.continue;
      }
      throw new Error(`Unexpected result from OnPostAuth. Expected OnPostAuthResult or KibanaResponse, but given: ${result}.`);
    } catch (error) {
      log.error(error);
      return hapiResponseAdapter.toInternalError();
    }
  };
}