/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.contentConnectors_bundle_jsonpfunction=self.contentConnectors_bundle_jsonpfunction||[]).push([[534],{4534:(e,n,t)=>{t.r(n),t.d(n,{default:()=>P});var o=t(4286),a=t.n(o),s=t(2553),i=t(1319),r=t(5008),l=t(409),c=t(4599),u=t(6358),d=t(4097),x=t(5893),p=t(6791),g=t(3850);const m=r.i18n.translate("xpack.contentConnectors.techPreview",{defaultMessage:"Tech preview"}),C=r.i18n.translate("xpack.contentConnectors.beta",{defaultMessage:"Beta"});var f={name:"1qmr6ab",styles:"overflow:auto"};const j=({selfManaged:e,disabled:n})=>{var t;const{services:{http:a,application:u}}=(0,l.useKibana)(),{euiTheme:d}=(0,i.useEuiTheme)(),[j,h]=(0,o.useState)([]),[E,y]=(0,o.useState)([]),{connectorTypes:b}=(0,c.Us)(),v=(0,o.useMemo)((()=>b.sort(((e,n)=>e.name.localeCompare(n.name)))),[b]),{selectedConnector:S}=(0,s.CZ)((0,x.W)({http:a,navigateToUrl:null==u?void 0:u.navigateToUrl})),{setSelectedConnector:k}=(0,s.dN)((0,x.W)({http:a,navigateToUrl:null==u?void 0:u.navigateToUrl})),M=v.map(((n,t)=>{const o=[];let a="";return n.isTechPreview&&(o.push((0,p.jsx)(i.EuiBadge,{"aria-label":m,key:t+"-preview",iconType:"beaker",color:"hollow"},m)),a+=`, ${m}`),n.isBeta&&(o.push((0,p.jsx)(i.EuiBadge,{"aria-label":C,key:t+"-beta",iconType:"beta",color:"hollow"},C)),a+=`, ${C}`),"native"!==e||n.isNative||o.push((0,p.jsx)(i.EuiBadge,{key:t+"-self",iconType:"warning",color:"warning"},g.fo)),{_append:o,_prepend:(0,p.jsx)(i.EuiIcon,{size:"l",type:n.iconPath}),"aria-label":n.name+a,key:t.toString(),label:n.name}}));return(0,o.useEffect)((()=>{y(M)}),[e]),(0,p.jsx)(i.EuiComboBox,{isDisabled:n,"aria-label":r.i18n.translate("xpack.contentConnectors.createConnector.chooseConnectorSelectable.euiComboBox.accessibleScreenReaderLabelLabel",{defaultMessage:"Select a data source for your connector to use."}),prepend:(0,p.jsx)(i.EuiIcon,{type:null!==(t=null==S?void 0:S.iconPath)&&void 0!==t?t:"plugs",size:"l"}),singleSelection:!0,fullWidth:!0,placeholder:r.i18n.translate("xpack.contentConnectors.createConnector.chooseConnectorSelectable.placeholder.text",{defaultMessage:"Choose a data source"}),options:E,selectedOptions:j,onChange:e=>{if(h(e),0===e.length)return void k(null);const n=Number(e[0].key);k(v[n])},renderOption:(e,n,t)=>{const{_append:o,key:a,label:s,_prepend:r}=e;return(0,p.jsx)(i.EuiFlexGroup,{className:t,key:a+"-span",gutterSize:"m",responsive:!1,direction:"row"},(0,p.jsx)(i.EuiFlexItem,{grow:!1},r),(0,p.jsx)(i.EuiFlexItem,{css:f,grow:!0},(0,p.jsx)(i.EuiText,{textAlign:"left",size:"s"},(0,p.jsx)(i.EuiTextTruncate,{text:s,truncation:"end"}))),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiBadgeGroup,{gutterSize:"xs"},o)))},rowHeight:d.base/2*5})};var h=t(6428),E=t.n(h),y=t(1900),b=t(1132),v=t(5879),S=t(2787);const k=r.i18n.translate("xpack.contentConnectors.createConnector.manualConfiguration.cliLabel",{defaultMessage:"Command-line interface"}),M=r.i18n.translate("xpack.contentConnectors.createConnector.manualConfiguration.cliLinkText",{defaultMessage:"Connectors CLI"}),T=({flyoutContent:e,selfManagePreference:n,setIsFlyoutVisible:t})=>{const o=(0,i.useGeneratedHtmlId)({prefix:"simpleFlyoutTitle"}),{services:{http:c,application:u}}=(0,l.useKibana)(),{connectorName:d}=(0,s.CZ)((0,x.W)({http:c,navigateToUrl:null==u?void 0:u.navigateToUrl})),{setRawName:g,createConnector:m}=(0,s.dN)((0,x.W)({http:c,navigateToUrl:null==u?void 0:u.navigateToUrl})),{euiTheme:C}=(0,i.useEuiTheme)();return(0,p.jsx)(i.EuiFlyout,{ownFocus:!0,onClose:()=>t(!1),"aria-labelledby":o,size:"s",maskProps:{style:`z-index: ${Number(C.levels.menu)+1}`}},"manual_config"===e&&(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiFlyoutHeader,{hasBorder:!0},(0,p.jsx)(i.EuiTitle,{size:"m"},(0,p.jsx)("h2",{id:o},r.i18n.translate("xpack.contentConnectors.createConnector.manualConfiguration.h2.cliLabel",{defaultMessage:"Manual configuration"}))),(0,p.jsx)(i.EuiSpacer,{size:"s"}),(0,p.jsx)(i.EuiText,{color:"subdued",size:"s"},(0,p.jsx)("p",null,(0,p.jsx)(v.FormattedMessage,{id:"xpack.contentConnectors..createConnector.flyoutManualConfigContent.p.thisManualOptionIsLabel",defaultMessage:"This manual option enables you to use an existing index and/or API key. It's an alternative to the automated {generateConfig} process.",values:{generateConfig:(0,p.jsx)("b",null,r.i18n.translate("xpack.contentConnectors.createConnector.manualConfiguration.generateConfigLinkLabel",{defaultMessage:"Generate configuration"}))}})))),(0,p.jsx)(i.EuiFlyoutBody,null,(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiPanel,{hasBorder:!0},(0,p.jsx)(i.EuiTitle,{size:"s"},(0,p.jsx)("h3",null,r.i18n.translate("xpack.contentConnectors.createConnector.manualConfiguration.connectorName",{defaultMessage:"Connector"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiFormRow,{fullWidth:!0,label:r.i18n.translate("xpack.contentConnectors.createConnector.startStep.euiFormRow.connectorNameLabel",{defaultMessage:"Connector name"})},(0,p.jsx)(i.EuiFieldText,{"data-test-subj":"enterpriseSearchStartStepFieldText",fullWidth:!0,name:"first",value:d,onChange:e=>{g(e.target.value)}})),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiText,{size:"xs"},(0,p.jsx)("p",null,r.i18n.translate("xpack.contentConnectors.createConnector.manualConfiguration.p.connectorNameDescription",{defaultMessage:"You'll be redirected to the connector page to complete your configuration."})))))),(0,p.jsx)(i.EuiFlyoutFooter,null,(0,p.jsx)(i.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiButtonEmpty,{"data-test-subj":"enterpriseSearchFlyoutManualConfigContentCloseButton",iconType:"cross",onClick:()=>t(!1),flush:"left"},r.i18n.translate("xpack.contentConnectors.createConnector.flyoutManualConfigContent.closeButtonEmptyLabel",{defaultMessage:"Close"}))),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiButton,{"data-test-subj":"enterpriseSearchFlyoutManualConfigContentSaveButton",onClick:()=>{m({isSelfManaged:"selfManaged"===n,shouldGenerateAfterCreate:!1,shouldNavigateToConnectorAfterCreate:!0})},fill:!0},r.i18n.translate("xpack.contentConnectors.createConnector.flyoutManualConfigContent.saveConfigurationButtonLabel",{defaultMessage:"Save configuration"})))))),"client"===e&&(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiFlyoutHeader,{hasBorder:!0},(0,p.jsx)(i.EuiTitle,{size:"m"},(0,p.jsx)("h2",{id:o},k))),(0,p.jsx)(i.EuiFlyoutBody,null,(0,p.jsx)(i.EuiText,{size:"s"},(0,p.jsx)("p",null,(0,p.jsx)(v.FormattedMessage,{id:"xpack.contentConnectors.createConnector.manualConfiguration.p.youCanAlsoUseLabel",defaultMessage:"You can also use the {cliLink} to create and manage connectors. The following command creates a new connector using the {myIndex} index. Configuration is defined in your {configFile} file.",values:{cliLink:(0,p.jsx)(i.EuiLink,{"data-test-subj":"enterpriseSearchManualConfigurationConnectorsCliLink",href:"https://github.com/elastic/connectors/blob/main/docs/CLI.md",target:"_blank",external:!0},M),myIndex:(0,p.jsx)(i.EuiCode,null,"my-index"),configFile:(0,p.jsx)(i.EuiCode,null,"config.yml")}}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiCodeBlock,{language:"bash",isCopyable:!0},S.vZ.CLI_SNIPPET))))},I=({isDisabled:e,selfManagePreference:n})=>{const{euiTheme:t}=(0,i.useEuiTheme)(),{services:{http:u,application:d}}=(0,l.useKibana)(),{plugins:{share:g,console:m}}=(0,c.Us)(),[C,f]=(0,o.useState)(!1),j=(0,i.useGeneratedHtmlId)({prefix:"splitButtonPopover"}),h=()=>{f(!1)},{selectedConnector:v,rawName:S}=(0,s.CZ)((0,x.W)({http:u,navigateToUrl:null==d?void 0:d.navigateToUrl})),[k,M]=(0,o.useState)(!1),[I,w]=(0,o.useState)(),F=[(0,p.jsx)(i.EuiContextMenuItem,{key:"copy",icon:"wrench",onClick:()=>{w("manual_config"),M(!0)}},r.i18n.translate("xpack.contentConnectors.createConnector.finishUpStep.manageAttachedIndexContextMenuItemLabel",{defaultMessage:"Manual configuration"})),(0,p.jsx)(i.EuiContextMenuItem,{key:"edit",icon:"console",onClick:()=>{h()},css:(0,p.css)(".euiLink{color:",t.colors.text,";font-weight:",t.font.weight.regular,";}","")},(0,p.jsx)(b.e,{application:d,sharePlugin:g,consolePlugin:m,content:r.i18n.translate("xpack.contentConnectors.createConnector.flyoutManualConfigContent.TryInConsoleLabel",{defaultMessage:"Run in Console"}),type:"link",request:(()=>{const e=null!=v&&v.serviceType?y.n2[v.serviceType]:void 0;if(!e)return"";const n=Object.entries(e.configuration).map((([e,n])=>`    "${e}": ${n?JSON.stringify(n.value):null}`)).join(",\n");return E()` # Example of how to create a ${null==e?void 0:e.name} connector using the API
# This also creates related resources like an index and an API key.
# This is an alternative to using the UI creation flow.

# 1. Create an index
PUT connector-${S}
{
  "settings": {
    "index": {
      "number_of_shards": 3,
      "number_of_replicas": 2
    }
  }
}  
# 2. Create a connector
PUT _connector/${S}
{
  "name": "My ${null==e?void 0:e.name} connector",
  "index_name":  "connector-${S}",
  "service_type": "${null==v?void 0:v.serviceType}"
}
# 3. Create an API key
POST /_security/api_key
{
  "name": "${S}-api-key",
  "role_descriptors": {
    "${null==v?void 0:v.serviceType}-api-key-role": {
      "cluster": [
        "monitor",
        "manage_connector"
      ],
      "indices": [
        {
          "names": [
            "connector-${S}",
            ".search-acl-filter-connector-${S}",
            ".elastic-connectors*"
          ],
          "privileges": [
            "all"
          ],
          "allow_restricted_indices": false
        }
      ]
    }
  }
}

# 🔧 Configure your connector
# NOTE: Configuration keys differ per service type.
PUT _connector/${S}/_configuration
{
  "values": {
${n}
  }
}

# 🔌 Verify your connector is connected
GET _connector/${S}

# 🔄 Sync data
POST _connector/_sync_job
{
  "id": "${S}",
  "job_type": "full"
}

# ⏳ Check sync status
GET _connector/_sync_job?connector_id=${S}&size=1

# Once the job completes, the status should return completed
# 🎉 Verify that data is present in the index with the following API call 
GET connector-${S}/_count

# 🔎 Elasticsearch stores data in documents, which are JSON objects. List the individual documents with the following API call
GET connector-${S}/_search
`})()})),(0,p.jsx)(i.EuiContextMenuItem,{key:"share",icon:"console",onClick:()=>{w("client"),M(!0)}},r.i18n.translate("xpack.contentConnectors.createConnector.finishUpStep.scheduleASyncContextMenuItemLabel",{defaultMessage:"Try with CLI"}))];return(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiPopover,{id:j,button:(0,p.jsx)(i.EuiButtonIcon,{"data-test-subj":"enterpriseSearchFinishUpStepButton",display:"fill",disabled:e,size:"m",iconType:"boxesVertical","aria-label":r.i18n.translate("xpack.contentConnectors.createConnector.finishUpStep.euiButtonIcon.moreLabel",{defaultMessage:"More"}),onClick:()=>{f(!C)}}),isOpen:C,closePopover:h,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,p.jsx)(i.EuiContextMenuPanel,{items:F})),k&&(0,p.jsx)(T,{setIsFlyoutVisible:M,flyoutContent:I,selfManagePreference:n}))};function w(e){const n=encodeURI(e).split(/%(?:u[0-9A-F]{2})?[0-9A-F]{2}|./).length-1,t=new RegExp('[\\\\/:*?"<>|\\s,#]+');return!(n>255||e!==e.toLowerCase()||"."===e||".."===e||null!==e.match(/^[-_+]/)||null!==e.match(t))}const F=[{description:r.i18n.translate("xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.native.chooseADataSourceLabel",{defaultMessage:"Choose a data source you would like to sync"}),icons:[(0,p.jsx)(i.EuiIcon,{size:"l",type:"documents"})],id:"native-choose-source"},{description:r.i18n.translate("xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.native.configureConnectorLabel",{defaultMessage:"Configure your connector using our Kibana UI"}),icons:[(0,p.jsx)(i.EuiIcon,{size:"l",type:"plugs"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"logoElastic"})],id:"native-configure-connector"}],z=[{description:r.i18n.translate("xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.client.chooseADataSourceLabel",{defaultMessage:"Choose a data source you would like to sync"}),icons:[(0,p.jsx)(i.EuiIcon,{size:"l",type:"documents"})],id:"client-choose-source"},{description:r.i18n.translate("xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.client.configureConnectorLabel",{defaultMessage:"Deploy connector code on your own infrastructure by running from source or using Docker"}),icons:[(0,p.jsx)(i.EuiIcon,{size:"l",type:"plugs"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"sortRight"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"launch"})],id:"client-deploy"},{description:r.i18n.translate("xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.client.enterDetailsLabel",{defaultMessage:"Enter access and connection details for your data source"}),icons:[(0,p.jsx)(i.EuiIcon,{size:"l",type:"documents"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"sortRight"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"plugs"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"sortRight"}),(0,p.jsx)(i.EuiIcon,{size:"l",type:"logoElastic"})],id:"client-configure-connector"}];var B={name:"15xgxri",styles:"max-width:700px"};const L=({isNative:e,showIsOnlySelfManaged:n,isElasticManagedDiscontinued:t})=>{const[s,l]=(0,o.useState)(!1),u=e?F:z,{isAgentlessEnabled:d}=(0,c.Us)();return(0,p.jsx)(i.EuiPopover,{anchorPosition:"upCenter",button:(0,p.jsx)(i.EuiButtonIcon,{"aria-label":r.i18n.translate("xpack.contentConnectors.createConnector.info",{defaultMessage:"More information"}),"data-test-subj":"enterpriseSearchConnectorDescriptionPopoverButton",iconType:"info",onClick:()=>l(!s)}),isOpen:s,closePopover:()=>{l(!1)}},(0,p.jsx)(i.EuiPanel,{css:B,hasBorder:!1,hasShadow:!1},(e&&!d||n)&&!t&&(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiFlexGroup,null,(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiCallOut,{announceOnMount:!0,title:n?r.i18n.translate("xpack.contentConnectors.createConnector.connectorDescriptionBadge.isOnlySelfManagedAvailableTitle",{defaultMessage:"This connector is not available as an Elastic-managed Connector"}):r.i18n.translate("xpack.contentConnectors.createConnector.connectorDescriptionBadge.isRunningLocallyTitle",{defaultMessage:"Elastic managed connectors are only available in Elastic Cloud"}),size:"s",iconType:"warning",color:"warning"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"})),t&&(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiFlexGroup,null,(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiCallOut,{announceOnMount:!0,title:r.i18n.translate("xpack.contentConnectors.createConnector.connectorDescriptionBadge.elasticManagedDiscontinuedTitle",{defaultMessage:"Elastic managed Connector are no longer supported"}),size:"s",iconType:"warning",color:"warning"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"})),(e&&d||!e)&&(0,p.jsx)(i.EuiFlexGroup,null,u.map((e=>(0,p.jsx)(i.EuiFlexItem,{grow:!1,key:e.id},(0,p.jsx)(i.EuiFlexGroup,{direction:"column",alignItems:"center",gutterSize:"s",style:{maxWidth:200}},(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiFlexGroup,{responsive:!1,gutterSize:"s"},e.icons.map(((e,n)=>(0,p.jsx)(i.EuiFlexItem,{grow:!1,key:n},e))))),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiText,{size:"s",grow:!1,textAlign:"center"},(0,p.jsx)("p",null,e.description)))))))),e&&!d&&!t&&(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiFlexGroup,{direction:"column",justifyContent:"center"},(0,p.jsx)(i.EuiFlexItem,{grow:!0},(0,p.jsx)(i.EuiText,{textAlign:"center"},(0,p.jsx)("h3",null,r.i18n.translate("xpack.contentConnectors.createConnector.connectorDescriptionBadge.learnMore",{defaultMessage:"Explore Elastic Cloud with your 14-day free trial"})))),(0,p.jsx)(i.EuiFlexItem,{grow:!0},(0,p.jsx)(i.EuiText,{size:"s",textAlign:"center",color:"subdued"},r.i18n.translate("xpack.contentConnectors.createConnector.connectorDescriptionBadge.learnMore",{defaultMessage:"Take advantage of Elastic managed connectors and generative AI capabilities to address search challenges across your organization in real time, at scale."}))),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiButton,{"data-test-subj":"enterprisecontentConnectors.tartFreeTrialButton",href:"https://cloud.elastic.co/registration?onboarding_token=connectors",target:"_blank"},r.i18n.translate("xpack.contentConnectors.createConnector.startTrialButtonLabel",{defaultMessage:"Start free trial"})))))))},P=({title:e,selfManagePreference:n,onSelfManagePreferenceChange:t,setCurrentStep:o,error:m})=>{const C=(0,i.useIsWithinBreakpoints)(["xs","s","m","l"]),f=(0,i.useGeneratedHtmlId)({prefix:"elasticManagedRadioButton"}),h=(0,i.useGeneratedHtmlId)({prefix:"selfManagedRadioButton"}),{services:{http:E,application:y}}=(0,l.useKibana)(),{isAgentlessEnabled:b}=(0,c.Us)(),{rawName:v,canConfigureConnector:S,selectedConnector:k,generatedConfigData:M,isGenerateLoading:T,isCreateLoading:F,isFormDirty:z}=(0,s.CZ)((0,x.W)({http:E,navigateToUrl:null==y?void 0:y.navigateToUrl})),{setRawName:B,createConnector:P,generateConnectorName:_,setFormDirty:D}=(0,s.dN)((0,x.W)({http:E,navigateToUrl:null==y?void 0:y.navigateToUrl})),{connector:N}=(0,s.CZ)((0,d.L)({http:E})),U=w(v)?m:r.i18n.translate("xpack.contentConnectors.createConnector.startStep.euiFormRow.nameInputHelpText.lineOne",{defaultMessage:"{connectorName} is an invalid index name",values:{connectorName:v}});return(0,p.jsx)(i.EuiForm,{component:"form",id:"enterprise-search-create-connector"},(0,p.jsx)(i.EuiFlexGroup,{gutterSize:"m",direction:"column"},(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiPanel,{hasShadow:!1,hasBorder:!0,paddingSize:"l"},(0,p.jsx)(i.EuiTitle,{size:"m"},(0,p.jsx)("h3",null,e)),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiFlexGroup,{direction:C?"column":"row"},(0,p.jsx)(i.EuiFlexItem,{grow:7},(0,p.jsx)(i.EuiFormRow,{fullWidth:!0,label:r.i18n.translate("xpack.contentConnectors.createConnector.startStep.euiFormRow.connectorLabel",{defaultMessage:"Connector"})},(0,p.jsx)(j,{selfManaged:n,disabled:!!N}))),(0,p.jsx)(i.EuiFlexItem,{grow:5},(0,p.jsx)(i.EuiFormRow,{fullWidth:!0,isInvalid:!!m,label:r.i18n.translate("xpack.contentConnectors.createConnector.startStep.euiFormRow.connectorNameLabel",{defaultMessage:"Connector name"}),helpText:(0,p.jsx)(a().Fragment,null,(0,p.jsx)(i.EuiText,{size:"xs",grow:!1,color:"danger"},U),(0,p.jsx)(i.EuiText,{size:"xs",grow:!1},r.i18n.translate("xpack.contentConnectors.startStep.namesShouldBeLowercaseTextLabel",{defaultMessage:"The connector name should be lowercase and cannot contain spaces or special characters."})))},(0,p.jsx)(i.EuiFieldText,{isInvalid:!!m,"data-test-subj":"enterpriseSearchStartStepFieldText",fullWidth:!0,name:"connectorName",value:v,onChange:e=>{B(e.target.value)},disabled:!!N,onBlur:()=>{k&&_({connectorName:v,connectorType:k.serviceType,isManagedConnector:k.isNative,http:E})}})))))),(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiPanel,{hasShadow:!1,hasBorder:!0,paddingSize:"l"},(0,p.jsx)(i.EuiTitle,{size:"s"},(0,p.jsx)("h4",null,r.i18n.translate("xpack.contentConnectors.createConnector.startStep.h4.setUpLabel",{defaultMessage:"Setup"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiText,{size:"s"},(0,p.jsx)("p",null,r.i18n.translate("xpack.contentConnectors.createConnector.startStep.p.whereDoYouWantLabel",{defaultMessage:"Choose how to deploy and manage your connector:"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiFlexGroup,{gutterSize:"xs"},(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiRadio,{id:f,label:r.i18n.translate("xpack.contentConnectors.createConnector.startStep.euiRadio.elasticManagedLabel",{defaultMessage:"Elastic managed"}),checked:"native"===n,disabled:!1===(null==k?void 0:k.isNative)||!b||z,onChange:()=>t("native"),name:"setUp"})),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(L,{showIsOnlySelfManaged:!1===(null==k?void 0:k.isNative),isNative:!0})),"   ",(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiRadio,{id:h,label:r.i18n.translate("xpack.contentConnectors.createConnector.startStep.euiRadio.selfManagedLabel",{defaultMessage:"Self-managed"}),checked:"selfManaged"===n,disabled:z,onChange:()=>t("selfManaged"),name:"setUp"})),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(L,{showIsOnlySelfManaged:!1,isNative:!1}))))),"selfManaged"===n?(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiPanel,{hasShadow:!1,hasBorder:!0,paddingSize:"l",color:null!=k&&k.name&&w(v)&&!m?"plain":"subdued"},(0,p.jsx)(i.EuiText,{color:null!=k&&k.name&&w(v)&&!m?"default":"subdued"},(0,p.jsx)("h3",null,r.i18n.translate("xpack.contentConnectors.createConnector.startStep.h4.deploymentLabel",{defaultMessage:"Deployment"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiText,{color:null!=k&&k.name&&w(v)?"default":"subdued",size:"s"},(0,p.jsx)("p",null,r.i18n.translate("xpack.contentConnectors.createConnector.startStep.p.youWillStartTheLabel",{defaultMessage:"We'll automatically configure your index, API key, and connector ID. Alternatively, create these manually and use a custom configuration."}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiButton,{"data-test-subj":"enterpriseSearchStartStepNextButton",onClick:()=>{k&&k.name&&(P({isSelfManaged:!0}),D(!0),o("deployment"))},fill:!0,disabled:!S||!w(v)||Boolean(m),isLoading:F||T},g.k5))):(0,p.jsx)(i.EuiFlexItem,null,(0,p.jsx)(i.EuiPanel,{color:null!=k&&k.name&&w(v)&&!m?"plain":"subdued",hasShadow:!1,hasBorder:!0,paddingSize:"l"},(0,p.jsx)(i.EuiText,{color:null!=k&&k.name&&w(v)&&!m?"default":"subdued"},(0,p.jsx)("h3",null,r.i18n.translate("xpack.contentConnectors.createConnector.startStep.h4.configureIndexAndAPILabel",{defaultMessage:"Configure index and API key"}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiText,{color:null!=k&&k.name&&w(v)&&!m?"default":"subdued",size:"s"},(0,p.jsx)("p",null,r.i18n.translate("xpack.contentConnectors.createConnector.startStep.p.thisProcessWillCreateLabel",{defaultMessage:"This process will create a new index, API key, and a Connector ID. Optionally you can bring your own configuration as well."}))),(0,p.jsx)(i.EuiSpacer,{size:"m"}),M&&N?(0,p.jsx)(a().Fragment,null,(0,p.jsx)(u.l,{apiKey:{api_key:M.apiKey.api_key,encoded:M.apiKey.encoded,id:M.apiKey.id,name:M.apiKey.name},connector:N,isGenerateLoading:!1}),(0,p.jsx)(i.EuiSpacer,{size:"m"}),(0,p.jsx)(i.EuiButton,{"data-test-subj":"enterpriseSearchStartStepGenerateConfigurationButton",fill:!0,onClick:()=>{o("configure")}},g.k5)):(0,p.jsx)(i.EuiFlexGroup,{gutterSize:"xs"},(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(i.EuiButton,{"data-test-subj":"entSearchContent-connector-configuration-generateConfigButton","data-telemetry-id":"entSearchContent-connector-configuration-generateConfigButton",disabled:!S||!w(v)||Boolean(m),fill:!0,iconType:"sparkles",isLoading:T||F,onClick:()=>{D(!0),P({isSelfManaged:!1})}},r.i18n.translate("xpack.contentConnectors.content.connector_detail.configurationConnector.steps.generateApiKey.button.label",{defaultMessage:"Generate configuration"}))),(0,p.jsx)(i.EuiFlexItem,{grow:!1},(0,p.jsx)(I,{isDisabled:T||F||!S||!w(v)||Boolean(m),selfManagePreference:n})))))))}}}]);