"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detailsConnectorBreadcrumbs = exports.ConnectorDetailTabId = exports.ConnectorDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _routes = require("../routes");
var _connector_scheduling = require("../search_index/connector/connector_scheduling");
var _connector_rules = require("../search_index/connector/sync_rules/connector_rules");
var _connector_configuration = require("./connector_configuration");
var _connector_view_logic = require("./connector_view_logic");
var _overview = require("./overview");
var _encode_path_params = require("../shared/encode_path_params");
var _documents = require("../search_index/documents");
var _index_mappings = require("../search_index/index_mappings");
var _connector_name = require("./connector_name");
var _connector_description = require("./connector_description");
var _page_template = require("../shared/page_template");
var _connectors = require("../connectors/connectors");
var _use_breadcrumbs = require("../../utils/use_breadcrumbs");
var _use_kibana = require("../../utils/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/connector_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let ConnectorDetailTabId = exports.ConnectorDetailTabId = /*#__PURE__*/function (ConnectorDetailTabId) {
  ConnectorDetailTabId["OVERVIEW"] = "overview";
  ConnectorDetailTabId["DOCUMENTS"] = "documents";
  ConnectorDetailTabId["INDEX_MAPPINGS"] = "index_mappings";
  ConnectorDetailTabId["PIPELINES"] = "pipelines";
  ConnectorDetailTabId["CONFIGURATION"] = "configuration";
  ConnectorDetailTabId["SYNC_RULES"] = "sync_rules";
  ConnectorDetailTabId["SCHEDULING"] = "scheduling";
  return ConnectorDetailTabId;
}({});
const detailsConnectorBreadcrumbs = exports.detailsConnectorBreadcrumbs = [..._connectors.connectorsBreadcrumbs, {
  text: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.detailsBreadcrumb', {
    defaultMessage: 'Connector Details'
  })
}];
const ConnectorDetail = () => {
  const connectorId = decodeURIComponent((0, _reactRouterDom.useParams)().connectorId);
  const {
    services: {
      chrome,
      appParams
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _use_breadcrumbs.useBreadcrumbs)(detailsConnectorBreadcrumbs, appParams, chrome);
  const {
    services: {
      application,
      http
    }
  } = (0, _public.useKibana)();
  const {
    hasFilteringFeature,
    index,
    connector,
    isLoading
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    fetchConnectorApiReset,
    startConnectorPoll,
    stopConnectorPoll
  } = (0, _kea.useActions)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  (0, _react.useEffect)(() => {
    stopConnectorPoll();
    fetchConnectorApiReset();
    startConnectorPoll(connectorId);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connectorId]);
  const {
    tabId = ConnectorDetailTabId.OVERVIEW
  } = (0, _reactRouterDom.useParams)();
  const ALL_INDICES_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_overview.ConnectorDetailOverview, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 16
      }
    }),
    id: ConnectorDetailTabId.OVERVIEW,
    isSelected: tabId === ConnectorDetailTabId.OVERVIEW,
    label: _i18n.i18n.translate('xpack.contentConnectors.connectors.connectorDetail.overviewTabLabel', {
      defaultMessage: 'Overview'
    }),
    onClick: () => {
      application === null || application === void 0 ? void 0 : application.navigateToUrl(`${(0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
        connectorId,
        tabId: ConnectorDetailTabId.OVERVIEW
      })}`);
    }
  }, {
    content: /*#__PURE__*/_react.default.createElement(_documents.SearchIndexDocuments, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 16
      }
    }),
    disabled: !index,
    id: ConnectorDetailTabId.DOCUMENTS,
    isSelected: tabId === ConnectorDetailTabId.DOCUMENTS,
    label: _i18n.i18n.translate('xpack.contentConnectors.connectors.connectorDetail.documentsTabLabel', {
      defaultMessage: 'Documents'
    }),
    onClick: () => {
      application === null || application === void 0 ? void 0 : application.navigateToUrl(`${(0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
        connectorId,
        tabId: ConnectorDetailTabId.DOCUMENTS
      })}`);
    }
  }, {
    content: /*#__PURE__*/_react.default.createElement(_index_mappings.SearchIndexIndexMappings, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 16
      }
    }),
    disabled: !index,
    id: ConnectorDetailTabId.INDEX_MAPPINGS,
    isSelected: tabId === ConnectorDetailTabId.INDEX_MAPPINGS,
    label: _i18n.i18n.translate('xpack.contentConnectors.connectors.connectorDetail.indexMappingsTabLabel', {
      defaultMessage: 'Mappings'
    }),
    onClick: () => application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
      connectorId,
      tabId: ConnectorDetailTabId.INDEX_MAPPINGS
    }))
  }];
  const CONNECTOR_TABS = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_rules.ConnectorSyncRules, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 16
      }
    }),
    disabled: !index || !hasFilteringFeature,
    id: ConnectorDetailTabId.SYNC_RULES,
    isSelected: tabId === ConnectorDetailTabId.SYNC_RULES,
    label: _i18n.i18n.translate('xpack.contentConnectors.connectors.connectorDetail.syncRulesTabLabel', {
      defaultMessage: 'Sync rules'
    }),
    onClick: () => application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
      connectorId,
      tabId: ConnectorDetailTabId.SYNC_RULES
    }))
  }, {
    content: /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorScheduling, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 16
      }
    }),
    disabled: !(connector !== null && connector !== void 0 && connector.index_name),
    id: ConnectorDetailTabId.SCHEDULING,
    isSelected: tabId === ConnectorDetailTabId.SCHEDULING,
    label: _i18n.i18n.translate('xpack.contentConnectors.connectors.connectorDetail.schedulingTabLabel', {
      defaultMessage: 'Scheduling'
    }),
    onClick: () => application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
      connectorId,
      tabId: ConnectorDetailTabId.SCHEDULING
    }))
  }];
  const CONFIG_TAB = [{
    content: /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfiguration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 16
      }
    }),
    id: ConnectorDetailTabId.CONFIGURATION,
    isSelected: tabId === ConnectorDetailTabId.CONFIGURATION,
    label: _i18n.i18n.translate('xpack.contentConnectors.connectors.connectorDetail.configurationTabLabel', {
      defaultMessage: 'Configuration'
    }),
    onClick: () => application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
      connectorId,
      tabId: ConnectorDetailTabId.CONFIGURATION
    }))
  }];

  /* const PIPELINES_TAB = {
    content: <SearchIndexPipelines />,
    disabled: !index,
    id: ConnectorDetailTabId.PIPELINES,
    isSelected: tabId === ConnectorDetailTabId.PIPELINES,
    label: i18n.translate(
      'xpack.contentConnectors.connectors.connectorDetail.pipelinesTabLabel',
      {
        defaultMessage: 'Pipelines',
      }
    ),
    onClick: () =>
      application?.navigateToUrl(
        generateEncodedPath(CONNECTOR_DETAIL_TAB_PATH, {
          connectorId,
          tabId: ConnectorDetailTabId.PIPELINES,
        })
      ),
  }; */

  const tabs = [...ALL_INDICES_TABS, ...CONNECTOR_TABS,
  // ...[PIPELINES_TAB],
  ...CONFIG_TAB];

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const selectedTab = (0, _react.useMemo)(() => tabs.find(tab => tab.id === tabId), [tabId]);
  if (!connector || connector !== null && connector !== void 0 && connector.deleted) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
      offset: 0,
      grow: true,
      restrictWidth: true,
      "data-test-subj": "svlSearchEditConnectorsPage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notFound', {
        defaultMessage: 'Could not find connector {connectorId}',
        values: {
          connectorId
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "serverlessSearchEditConnectorGoBackButton",
        color: "primary",
        fill: true,
        onClick: () => application === null || application === void 0 ? void 0 : application.navigateToUrl(`./`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.goBack', {
        defaultMessage: 'Go back'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.SearchConnectorsPageTemplateWrapper, {
    isLoading: isLoading,
    pageHeader: {
      description: connector ? /*#__PURE__*/_react.default.createElement(_connector_description.ConnectorDescription, {
        connector: connector,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 295,
          columnNumber: 34
        }
      }) : '...',
      pageTitle: connector ? /*#__PURE__*/_react.default.createElement(_connector_name.ConnectorName, {
        connector: connector,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 32
        }
      }) : '...',
      rightSideGroupProps: {
        gutterSize: 's',
        responsive: false,
        wrap: false
      },
      tabs: tabs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 5
    }
  }, (selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.content) || null);
};
exports.ConnectorDetail = ConnectorDetail;