"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiteralType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class LiteralType extends _type.Type {
  constructor(value) {
    super(_internals.internals.any().valid(value));
    (0, _defineProperty2.default)(this, "expectedValue", void 0);
    this.expectedValue = value;
  }
  handleError(type) {
    switch (type) {
      case 'any.required':
      case 'any.only':
        return `expected value to equal [${this.expectedValue}]`;
    }
  }
}
exports.LiteralType = LiteralType;