"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCustomFieldsFilterConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _builder = require("../../custom_fields/builder");
var _multi_select_filter = require("../multi_select_filter");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/table_filter_config/use_custom_fields_filter_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const customFieldFilterOptionFactory = ({
  buttonLabel,
  customFieldOptions,
  fieldKey,
  onFilterOptionsChange,
  type,
  isLoading
}) => {
  return {
    key: (0, _utils.flattenCustomFieldKey)(fieldKey),
    // this prefix is set in case custom field has the same key as a system field
    isActive: false,
    isAvailable: true,
    label: buttonLabel,
    getEmptyOptions: () => {
      return {
        customFields: {
          [fieldKey]: {
            type,
            options: []
          }
        }
      };
    },
    render: ({
      filterOptions
    }) => {
      var _filterOptions$custom;
      const onCustomFieldChange = ({
        filterId,
        selectedOptionKeys
      }) => {
        onFilterOptionsChange({
          customFields: {
            [(0, _utils.deflattenCustomFieldKey)(filterId)]: {
              options: selectedOptionKeys,
              type
            }
          }
        });
      };
      return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
        buttonLabel: buttonLabel,
        id: fieldKey,
        onChange: onCustomFieldChange,
        options: customFieldOptions.map(option => ({
          key: option.key,
          label: option.label
        })),
        selectedOptionKeys: ((_filterOptions$custom = filterOptions.customFields[fieldKey]) === null || _filterOptions$custom === void 0 ? void 0 : _filterOptions$custom.options) || [],
        isLoading: isLoading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      });
    }
  };
};
const useCustomFieldsFilterConfig = ({
  isSelectorView,
  customFields,
  isLoading,
  onFilterOptionsChange
}) => {
  const customFieldsFilterConfig = [];
  if (isSelectorView) {
    return {
      customFieldsFilterConfig: []
    };
  }
  for (const {
    key: fieldKey,
    type,
    label: buttonLabel
  } of customFields !== null && customFields !== void 0 ? customFields : []) {
    if (_builder.builderMap[type]) {
      const {
        filterOptions: customFieldOptions
      } = _builder.builderMap[type]();
      if (customFieldOptions) {
        customFieldsFilterConfig.push(customFieldFilterOptionFactory({
          buttonLabel,
          customFieldOptions,
          fieldKey,
          onFilterOptionsChange,
          type,
          isLoading
        }));
      }
    }
  }
  return {
    customFieldsFilterConfig
  };
};
exports.useCustomFieldsFilterConfig = useCustomFieldsFilterConfig;