"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomElementService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lib = require("../../common/lib");
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CanvasCustomElementService {
  constructor() {
    (0, _defineProperty2.default)(this, "apiPath", `${_lib.API_ROUTE_CUSTOM_ELEMENT}`);
  }
  async create(customElement) {
    await _kibana_services.coreServices.http.post(this.apiPath, {
      body: JSON.stringify(customElement),
      version: '1'
    });
  }
  async get(customElementId) {
    return await _kibana_services.coreServices.http.get(`${this.apiPath}/${customElementId}`, {
      version: '1'
    }).then(({
      data: element
    }) => element);
  }
  async update(id, element) {
    await _kibana_services.coreServices.http.put(`${this.apiPath}/${id}`, {
      body: JSON.stringify(element),
      version: '1'
    });
  }
  async remove(id) {
    await _kibana_services.coreServices.http.delete(`${this.apiPath}/${id}`, {
      version: '1'
    });
  }
  async find(searchTerm) {
    return await _kibana_services.coreServices.http.get(`${this.apiPath}/find`, {
      query: {
        name: searchTerm,
        perPage: 10000
      },
      version: '1'
    });
  }
}
let canvasCustomElementService;
const getCustomElementService = () => {
  if (!canvasCustomElementService) {
    canvasCustomElementService = new CanvasCustomElementService();
  }
  return canvasCustomElementService;
};
exports.getCustomElementService = getCustomElementService;