"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabsControl = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/presentation-util-plugin/public");
var _common = require("../../../../common");
var _kibana_services = require("../../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/labs_control/labs_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getLabsButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderLabsControlSettings.labsButtonLabel', {
    defaultMessage: 'Labs'
  })
};
const Flyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
const LabsControl = () => {
  const [isShown, setIsShown] = (0, _react.useState)(false);
  if (!_kibana_services.coreServices.uiSettings.get(_common.UI_SETTINGS.ENABLE_LABS_UI)) {
    return null;
  }
  const projects = _kibana_services.presentationUtilService.labsService.getProjects(['canvas']);
  const overrideCount = Object.values(projects).filter(project => project.status.isOverride).length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsShown(!isShown),
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, strings.getLabsButtonLabel(), overrideCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    style: {
      marginLeft: 4
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, overrideCount) : null), isShown ? /*#__PURE__*/_react.default.createElement(Flyout, {
    solutions: ['canvas'],
    onClose: () => setIsShown(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 18
    }
  }) : null);
};
exports.LabsControl = LabsControl;