"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourcePreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/presentation-util-plugin/public");
var _error = require("../../../../canvas_plugin_src/renderers/error");
var _datatable = require("../../datatable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/datasource/datasource_preview/datasource_preview.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Error = (0, _public.withSuspense)(_error.LazyErrorComponent);
const strings = {
  getEmptyFirstLineDescription: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.emptyFirstLineDescription', {
    defaultMessage: "We couldn't find any documents matching your search criteria."
  }),
  getEmptySecondLineDescription: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.emptySecondLineDescription', {
    defaultMessage: 'Check your datasource settings and try again.'
  }),
  getEmptyTitle: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.emptyTitle', {
    defaultMessage: 'No documents found'
  }),
  getModalTitle: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.modalTitle', {
    defaultMessage: 'Datasource preview'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.saveButtonLabel', {
    defaultMessage: 'Save'
  })
};
const DatasourcePreview = ({
  done,
  datatable
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: done,
    maxWidth: "1000px",
    className: "canvasModal--fixedSize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, strings.getModalTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    className: "canvasDatasourcePreview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.canvas.datasourceDatasourcePreview.modalDescription",
    defaultMessage: "The following data will be available to the selected element upon clicking {saveLabel} in the sidebar.",
    values: {
      saveLabel: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 28
        }
      }, strings.getSaveButtonLabel())
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), datatable.type === 'error' ? /*#__PURE__*/_react.default.createElement(Error, {
    payload: datatable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "canvasDatasourcePreview__panel",
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, datatable.rows.length > 0 ? /*#__PURE__*/_react.default.createElement(_datatable.Datatable, {
    datatable: datatable,
    showHeader: true,
    paginate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 24
      }
    }, strings.getEmptyTitle()),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 19
      }
    }, strings.getEmptyFirstLineDescription(), /*#__PURE__*/_react.default.createElement("br", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 21
      }
    }), strings.getEmptySecondLineDescription()),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }))));
};
exports.DatasourcePreview = DatasourcePreview;
DatasourcePreview.propTypes = {
  datatable: _propTypes.default.object,
  done: _propTypes.default.func
};