"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreadcrumbsContext = void 0;
exports.BreadcrumbsContextProvider = BreadcrumbsContextProvider;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../kibana_context/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/breadcrumbs/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BreadcrumbsContext = exports.BreadcrumbsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function BreadcrumbsContextProvider({
  children
}) {
  const [, forceUpdate] = (0, _react.useState)({});
  const {
    services: {
      serverless
    }
  } = (0, _use_kibana.useKibana)();
  const breadcrumbs = (0, _react.useMemo)(() => {
    return new Map();
  }, []);
  const matches = (0, _typedReactRouterConfig.useMatchRoutes)();
  const api = (0, _react.useMemo)(() => ({
    set(route, breadcrumb) {
      if (!(0, _lodash.isEqual)(breadcrumbs.get(route), breadcrumb)) {
        breadcrumbs.set(route, breadcrumb);
        forceUpdate({});
      }
    },
    unset(route) {
      if (breadcrumbs.has(route)) {
        breadcrumbs.delete(route);
        forceUpdate({});
      }
    },
    getBreadcrumbs(currentMatches) {
      return (0, _lodash.compact)(currentMatches.flatMap(match => {
        const breadcrumb = breadcrumbs.get(match.route);
        return breadcrumb;
      }));
    }
  }), [breadcrumbs]);
  const formattedBreadcrumbs = api.getBreadcrumbs(matches).map((breadcrumb, index, array) => {
    return {
      text: breadcrumb.title,
      ...(index === array.length - 1 ? {} : {
        href: breadcrumb.href
      })
    };
  });
  (0, _public.useBreadcrumbs)(formattedBreadcrumbs, {
    serverless,
    absoluteProjectStyleBreadcrumbs: false
  });
  return /*#__PURE__*/_react.default.createElement(BreadcrumbsContext.Provider, {
    value: api,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 10
    }
  }, children);
}