"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectTo = RedirectTo;
exports.RenderRedirectTo = RenderRedirectTo;
exports.redirectTo = redirectTo;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/redirect_to.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Function that returns a react component to redirect to a given pathname removing hash-based URLs
 * @param pathname
 */
function redirectTo(pathname) {
  return ({
    location
  }) => {
    return /*#__PURE__*/_react.default.createElement(RenderRedirectTo, {
      location: location,
      pathname: pathname,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 12
      }
    });
  };
}

/**
 * React component to redirect to a given pathname removing hash-based URLs
 * @param param0
 */
function RedirectTo({
  pathname
}) {
  const location = (0, _reactRouterDom.useLocation)();
  return /*#__PURE__*/_react.default.createElement(RenderRedirectTo, {
    location: location,
    pathname: pathname,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 10
    }
  });
}
/**
 * Given a pathname, redirect to that location, preserving the search and maintaining
 * backward-compatibilty with legacy (pre-7.9) hash-based URLs.
 */
function RenderRedirectTo(props) {
  const {
    location
  } = props;
  let search = location.search;
  let pathname = props.pathname;

  // Redirect root URLs with a hash to support backward compatibility with URLs
  // from before we switched to the non-hash platform history.
  if (location.pathname === '' && location.hash.length > 0) {
    // We just want the search and pathname so the host doesn't matter
    const resolvedUrl = new URL(location.hash.slice(1), 'http://localhost');
    search = resolvedUrl.search;
    pathname = resolvedUrl.pathname;
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      ...location,
      hash: '',
      pathname,
      search
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 10
    }
  });
}