"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticsApmDocuments = DiagnosticsApmDocuments;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../common/utils/formatters");
var _use_adhoc_apm_data_view = require("../../../hooks/use_adhoc_apm_data_view");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _search_bar = require("../../shared/search_bar/search_bar");
var _use_diagnostics = require("./context/use_diagnostics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/apm_documents_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DiagnosticsApmDocuments() {
  var _diagnosticsBundle$pa;
  const {
    diagnosticsBundle,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const {
    discover
  } = (0, _public.useKibana)().services;
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const [sortField, setSortField] = (0, _react.useState)('name');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/diagnostics/documents');
  const items = (0, _react.useMemo)(() => {
    var _diagnosticsBundle$ap;
    return (_diagnosticsBundle$ap = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.apmEvents.filter(({
      legacy,
      docCount,
      intervals
    }) => {
      const isLegacyAndUnused = legacy === true && docCount === 0 && intervals && Object.values(intervals).every(interval => interval.eventDocCount === 0);
      return !isLegacyAndUnused;
    })) !== null && _diagnosticsBundle$ap !== void 0 ? _diagnosticsBundle$ap : [];
  }, [diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.apmEvents]);
  const columns = [{
    name: 'Name',
    field: 'name',
    width: '30%'
  }, {
    name: 'Doc count',
    field: 'docCount',
    render: (_, {
      docCount
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: `${(0, _formatters.asInteger)(docCount)} docs`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        cursor: 'pointer'
      },
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, (0, _formatters.asBigNumber)(docCount))),
    sortable: true
  }, {
    name: '1m',
    field: 'intervals.1m',
    render: (_, {
      intervals
    }) => {
      const interval = intervals === null || intervals === void 0 ? void 0 : intervals['1m'];
      return /*#__PURE__*/_react.default.createElement(IntervalDocCount, {
        interval: interval,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 16
        }
      });
    }
  }, {
    name: '10m',
    field: 'intervals.10m',
    render: (_, {
      intervals
    }) => {
      const interval = intervals === null || intervals === void 0 ? void 0 : intervals['10m'];
      return /*#__PURE__*/_react.default.createElement(IntervalDocCount, {
        interval: interval,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 16
        }
      });
    }
  }, {
    name: '60m',
    field: 'intervals.60m',
    render: (_, {
      intervals
    }) => {
      const interval = intervals === null || intervals === void 0 ? void 0 : intervals['60m'];
      return /*#__PURE__*/_react.default.createElement(IntervalDocCount, {
        interval: interval,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 16
        }
      });
    }
  }, {
    name: 'Actions',
    actions: dataView ? [{
      name: 'View',
      description: 'View in Discover',
      type: 'icon',
      icon: 'discoverApp',
      onClick: async item => {
        var _discover$locator, _dataView$id;
        await (discover === null || discover === void 0 ? void 0 : (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate({
          query: {
            language: 'kuery',
            query: item.kuery
          },
          dataViewId: (_dataView$id = dataView === null || dataView === void 0 ? void 0 : dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '',
          timeRange: rangeTo && rangeFrom ? {
            to: rangeTo,
            from: rangeFrom
          } : undefined
        }));
      }
    }] : []
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isImported && diagnosticsBundle ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticsApmDocuments.from:BadgeLabel', {
    defaultMessage: 'From: {date}',
    values: {
      date: new Date(diagnosticsBundle.params.start).toISOString()
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticsApmDocuments.to:BadgeLabel', {
    defaultMessage: 'To: {date}',
    values: {
      date: new Date(diagnosticsBundle.params.end).toISOString()
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticsApmDocuments.filter:BadgeLabel', {
    defaultMessage: 'Filter:'
  }), (_diagnosticsBundle$pa = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.params.kuery) !== null && _diagnosticsBundle$pa !== void 0 ? _diagnosticsBundle$pa : /*#__PURE__*/_react.default.createElement("em", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticsApmDocuments.em.emptyLabel', {
    defaultMessage: 'Empty'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "documents-table",
    items: (0, _lodash.orderBy)(items, sortField, sortDirection),
    sorting: {
      enableAllColumns: true,
      sort: {
        direction: sortDirection,
        field: sortField
      }
    },
    rowHeader: "firstName",
    columns: columns,
    onChange: ({
      sort
    }) => {
      if (sort) {
        setSortField(sort.field);
        setSortDirection(sort.direction);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }));
}
function IntervalDocCount({
  interval
}) {
  if (interval === undefined) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "-");
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: `${(0, _formatters.asInteger)(interval.metricDocCount)} docs / ${(0, _formatters.asInteger)(interval.eventDocCount)} events`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      cursor: 'pointer'
    },
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, (0, _formatters.asBigNumber)(interval.metricDocCount), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      fontStyle: 'italic',
      fontSize: '80%',
      display: 'inline'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.intervalDocCount.TextLabel', {
    defaultMessage: '({docCount} {docCount, plural, one {event} other {events}})',
    values: {
      docCount: (0, _formatters.asBigNumber)(interval.eventDocCount)
    }
  }))));
}