"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToSingleOrMultiValue = mapToSingleOrMultiValue;
exports.unflattenKnownApmEventFields = unflattenKnownApmEventFields;
var _unflatten_object = require("@kbn/observability-utils-common/object/unflatten_object");
var _merge_plain_objects = require("@kbn/observability-utils-common/object/merge_plain_objects");
var _utility_types = require("./utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function unflattenKnownApmEventFields(hitFields, requiredFields) {
  var _requiredFields$filte;
  if (!hitFields) {
    return undefined;
  }
  const missingRequiredFields = (_requiredFields$filte = requiredFields === null || requiredFields === void 0 ? void 0 : requiredFields.filter(key => {
    const value = hitFields === null || hitFields === void 0 ? void 0 : hitFields[key];
    return value === null || value === undefined || Array.isArray(value) && value.length === 0;
  })) !== null && _requiredFields$filte !== void 0 ? _requiredFields$filte : [];
  if (missingRequiredFields.length > 0) {
    throw new Error(`Missing required fields ${missingRequiredFields.join(', ')} in event`);
  }
  const copy = mapToSingleOrMultiValue({
    ...hitFields
  });
  const [knownFields, unknownFields] = Object.entries(copy).reduce((prev, [key, value]) => {
    if (_utility_types.ALL_FIELDS.has(key)) {
      prev[0][key] = value;
    } else {
      prev[1][key] = value;
    }
    return prev;
  }, [{}, {}]);
  const unflattened = (0, _merge_plain_objects.mergePlainObjects)((0, _unflatten_object.unflattenObject)(unknownFields), (0, _unflatten_object.unflattenObject)(knownFields));
  return unflattened;
}
function mapToSingleOrMultiValue(fields) {
  _utility_types.KNOWN_SINGLE_VALUED_FIELDS.forEach(field => {
    const value = fields[field];
    if (value !== null && value !== undefined) {
      fields[field] = Array.isArray(value) ? value[0] : value;
    }
  });
  return fields;
}