"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSampleDocuments = getSampleDocuments;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSampleDocuments({
  esClient,
  index,
  start,
  end,
  kql,
  filter,
  size = 1000,
  fields = [{
    field: '*',
    include_unmapped: true
  }],
  _source = false,
  timeout = '5s'
}) {
  return esClient.search({
    index,
    size,
    track_total_hits: true,
    timeout,
    query: {
      bool: {
        must: [...(0, _esQuery.kqlQuery)(kql), ...(0, _esQuery.dateRangeQuery)(start, end), ...(0, _lodash.castArray)(filter !== null && filter !== void 0 ? filter : [])],
        should: [{
          function_score: {
            functions: [{
              random_score: {}
            }]
          }
        }]
      }
    },
    sort: {
      _score: {
        order: 'desc'
      }
    },
    _source,
    fields
  }).then(response => {
    var _response$hits$total;
    return {
      hits: response.hits.hits,
      total: typeof response.hits.total === 'number' ? response.hits.total : (_response$hits$total = response.hits.total) === null || _response$hits$total === void 0 ? void 0 : _response$hits$total.value
    };
  });
}