"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPES = exports.EuiPaginationButtonArrow = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button_icon = require("../button/button_icon");
var _common = require("../common");
var _i18n = require("../i18n");
var _services = require("../../services");
var _pagination_button = require("./pagination_button.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var typeToIconTypeMap = {
  first: 'arrowStart',
  previous: 'arrowLeft',
  next: 'arrowRight',
  last: 'arrowEnd'
};
var TYPES = exports.TYPES = (0, _common.keysOf)(typeToIconTypeMap);
var EuiPaginationButtonArrow = exports.EuiPaginationButtonArrow = function EuiPaginationButtonArrow(_ref) {
  var className = _ref.className,
    type = _ref.type,
    disabled = _ref.disabled,
    ariaControls = _ref.ariaControls,
    onClick = _ref.onClick;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _pagination_button.euiPaginationButtonStyles)(euiTheme);
  var labels = {
    first: (0, _i18n.useEuiI18n)('euiPaginationButtonArrow.firstPage', 'First page'),
    previous: (0, _i18n.useEuiI18n)('euiPaginationButtonArrow.previousPage', 'Previous page'),
    next: (0, _i18n.useEuiI18n)('euiPaginationButtonArrow.nextPage', 'Next page'),
    last: (0, _i18n.useEuiI18n)('euiPaginationButtonArrow.lastPage', 'Last page')
  };
  var buttonProps = {};
  if (ariaControls && !disabled) {
    buttonProps.href = "#".concat(ariaControls);
    buttonProps['aria-controls'] = ariaControls;
  }
  return (0, _react2.jsx)(_button_icon.EuiButtonIcon, _extends({
    css: styles.euiPaginationButton,
    className: (0, _classnames.default)('euiPaginationArrowButton', className),
    color: "text",
    "aria-label": labels[type],
    title: disabled ? undefined : labels[type],
    isDisabled: disabled,
    onClick: onClick,
    "data-test-subj": "pagination-button-".concat(type),
    iconType: typeToIconTypeMap[type]
  }, buttonProps));
};
EuiPaginationButtonArrow.propTypes = {
  type: _propTypes.default.any.isRequired,
  disabled: _propTypes.default.bool,
  ariaControls: _propTypes.default.string
};