"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardUpdateOptionsSchema = void 0;
exports.getDashboardUpdateRequestAttributesSchema = getDashboardUpdateRequestAttributesSchema;
exports.getDashboardUpdateResultSchema = getDashboardUpdateResultSchema;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardUpdateOptionsSchema = exports.dashboardUpdateOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_contentManagementUtils.referenceSchema)),
  mergeAttributes: _configSchema.schema.maybe(_contentManagementUtils.updateOptionsSchema.mergeAttributes)
});
function getDashboardUpdateRequestAttributesSchema() {
  return _configSchema.schema.object({
    ...(0, _common.getDashboardStateSchema)(),
    type: _configSchema.schema.maybe(_configSchema.schema.string()),
    references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_contentManagementUtils.referenceSchema)),
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  });
}
function getDashboardUpdateResultSchema() {
  return (0, _common.getDashboardAPICreateResultSchema)();
}