"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.search = search;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _dashboard_saved_object = require("../../dashboard_saved_object");
var _transforms = require("../../content_management/v1/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function search(requestCtx, searchBody) {
  const {
    core
  } = await requestCtx.resolve(['core']);
  const soResponse = await core.savedObjects.client.find({
    type: _dashboard_saved_object.DASHBOARD_SAVED_OBJECT_TYPE,
    searchFields: ['title^3', 'description'],
    fields: ['description', 'title',
    // required fields to load timeRange
    'timeFrom', 'timeTo', 'timeRestore'],
    search: searchBody.search,
    perPage: searchBody.per_page,
    page: searchBody.page ? +searchBody.page : undefined,
    defaultSearchOperator: 'AND',
    ...(0, _contentManagementUtils.tagsToFindOptions)(searchBody.tags)
  });
  return {
    dashboards: soResponse.saved_objects.map(so => {
      const {
        description,
        tags,
        timeRange,
        title
      } = (0, _transforms.transformDashboardOut)(so.attributes, so.references);
      return {
        id: so.id,
        data: {
          ...(description && {
            description
          }),
          ...(tags && {
            tags
          }),
          ...(timeRange && {
            timeRange
          }),
          title: title !== null && title !== void 0 ? title : ''
        },
        meta: {
          createdAt: so.created_at,
          createdBy: so.created_by,
          error: so.error,
          managed: so.managed,
          updatedAt: so.updated_at,
          updatedBy: so.updated_by,
          version: so.version
        }
      };
    }),
    page: soResponse.page,
    total: soResponse.total
  };
}