"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchResponseBody = exports.searchRequestBody = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _schema = require("../../content_management/v1/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchRequestBody = exports.searchRequestBody = _configSchema.schema.object({
  page: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'The page of dashboards to return'
    }
  })),
  per_page: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'The number of dashboards to return per page'
    }
  })),
  search: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An Elasticsearch simple_query_string query that filters the dashboards in the response by "title" and "description"'
    }
  })),
  tags: _configSchema.schema.maybe(_configSchema.schema.object({
    included: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    excluded: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }))
});
const searchResponseBody = exports.searchResponseBody = _configSchema.schema.object({
  dashboards: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    data: _configSchema.schema.object({
      description: _configSchema.schema.maybe(_configSchema.schema.string()),
      tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      timeRange: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema),
      title: _configSchema.schema.string()
    }),
    meta: _schema.dashboardMetaSchema
  })),
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number()
});