"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateRoute = registerCreateRoute;
var _constants = require("../constants");
var _schemas = require("./schemas");
var _create = require("./create");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerCreateRoute(router) {
  const createRoute = router.post({
    path: _constants.PUBLIC_API_PATH,
    summary: 'Create a dashboard',
    ..._constants.commonRouteConfig
  });
  createRoute.addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: () => ({
      request: {
        body: (0, _schemas.getCreateRequestBody)()
      },
      response: {
        200: {
          body: _schemas.getCreateResponseBody
        }
      }
    })
  }, async (ctx, req, res) => {
    let result;
    try {
      result = await (0, _create.create)(ctx, req.body);
    } catch (e) {
      if (e.isBoom && e.output.statusCode === 409) {
        return res.conflict({
          body: {
            message: `A dashboard with ID ${req.body.id} already exists.`
          }
        });
      }
      if (e.isBoom && e.output.statusCode === 403) {
        return res.forbidden();
      }
      return res.badRequest({
        body: e
      });
    }
    return res.ok({
      body: result
    });
  });
}