"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountApp = mountApp;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRedux = require("react-redux");
var _shared_imports = require("../shared_imports");
var _breadcrumbs = require("./services/breadcrumbs");
var _documentation_links = require("./services/documentation_links");
var _app = require("./app");
var _store = require("./store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AppWithExecutionContext = ({
  history,
  executionContext,
  getUrlForApp
}) => {
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'crossClusterReplication'
  });
  return /*#__PURE__*/_react.default.createElement(_app.App, {
    history: history,
    getUrlForApp: getUrlForApp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 10
    }
  });
};
const renderApp = (startServices, element, history, getUrlForApp, executionContext) => {
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _store.ccrStore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AppWithExecutionContext, {
    history: history,
    getUrlForApp: getUrlForApp,
    executionContext: executionContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }))), element);
  return () => (0, _reactDom.unmountComponentAtNode)(element);
};
async function mountApp({
  startServices,
  element,
  setBreadcrumbs,
  docLinks,
  history,
  getUrlForApp,
  executionContext
}) {
  // Import and initialize additional services here instead of in plugin.ts to reduce the size of the
  // initial bundle as much as possible.
  (0, _breadcrumbs.init)(setBreadcrumbs);
  (0, _documentation_links.init)(docLinks);
  return renderApp(startServices, element, history, getUrlForApp, executionContext);
}