"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationFeedbackSnippet = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxFeedbackSnippet = require("@kbn/shared-ux-feedback-snippet");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/project/sidenav/navigation/navigation_feedback_snippet.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const feedbackSnippetId = 'sideNavigationFeedback';
const feedbackUrls = {
  es: 'https://ela.st/search-nav-feedback',
  workplaceai: 'https://ela.st/search-nav-feedback',
  oblt: 'https://ela.st/o11y-nav-feedback',
  security: 'https://ela.st/security-nav-feedback'
};
const feedbackButtonMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "core.ui.chrome.sideNavigation.sideNavigation.feedbackButtonText",
  defaultMessage: "Navigation feedback",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
});
const promptViewMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "core.ui.chrome.sideNavigation.feedbackPanel.promptTitle",
  defaultMessage: "How's the navigation working for you?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
});
const getSurveyFeedbackURL = (solutionId, feedbackUrlParams) => {
  const url = new URL(feedbackUrls[solutionId]);
  if (feedbackUrlParams) {
    feedbackUrlParams.forEach((value, key) => {
      url.searchParams.set(key, value);
    });
  }
  return url.href;
};
const NavigationFeedbackSnippet = ({
  solutionId,
  feedbackUrlParams
}) => {
  const feedbackSurveyUrl = getSurveyFeedbackURL(solutionId, feedbackUrlParams);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxFeedbackSnippet.FeedbackSnippet, {
    css: (0, _react2.css)`
        border-top: ${euiTheme.border.width.thin} ${euiTheme.colors.borderBaseSubdued} solid;
      `,
    feedbackButtonMessage: feedbackButtonMessage,
    feedbackSnippetId: feedbackSnippetId,
    promptViewMessage: promptViewMessage,
    surveyUrl: feedbackSurveyUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.NavigationFeedbackSnippet = NavigationFeedbackSnippet;