"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverSuggestionBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _options_list_strings = require("../options_list_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_popover_suggestion_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const OptionsListPopoverSuggestionBadge = ({
  documentCount
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _options_list_strings.OptionsListStrings.popover.getDocumentCountTooltip(documentCount),
    position: 'right',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "xs",
    "aria-hidden": true,
    className: "eui-textNumber",
    "data-test-subj": "optionsList-document-count-badge",
    css: styles.documentCountBadge,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 9
    }
  }, `${documentCount.toLocaleString()}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, '" "', " ", _options_list_strings.OptionsListStrings.popover.getDocumentCountScreenReaderText(documentCount))));
};
exports.OptionsListPopoverSuggestionBadge = OptionsListPopoverSuggestionBadge;
const styles = {
  documentCountBadge: ({
    euiTheme
  }) => (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.medium} !important;
    color: ${euiTheme.colors.textSubdued} !important;
  `
};