"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openDataControlEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _presentationUtil = require("@kbn/presentation-util");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/open_data_control_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const openDataControlEditor = ({
  initialState,
  controlType,
  controlId,
  initialDefaultPanelTitle,
  onSave,
  controlGroupApi
}) => {
  const onCancel = (newState, closeFlyout) => {
    if ((0, _reactFastCompare.default)(initialState, newState)) {
      closeFlyout();
      return;
    }
    _kibana_services.coreServices.overlays.openConfirm(_i18n.i18n.translate('controls.controlGroup.management.discard.sub', {
      defaultMessage: `Changes that you've made to this control will be discarded, are you sure you want to continue?`
    }), {
      confirmButtonText: _i18n.i18n.translate('controls.controlGroup.management.discard.confirm', {
        defaultMessage: 'Discard changes'
      }),
      cancelButtonText: _i18n.i18n.translate('controls.controlGroup.management.discard.cancel', {
        defaultMessage: 'Cancel'
      }),
      title: _i18n.i18n.translate('controls.controlGroup.management.discard.title', {
        defaultMessage: 'Discard changes?'
      }),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        closeFlyout();
      }
    });
  };
  (0, _presentationUtil.openLazyFlyout)({
    core: _kibana_services.coreServices,
    parentApi: controlGroupApi.parentApi,
    loadContent: async ({
      closeFlyout
    }) => {
      const {
        DataControlEditor
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./data_control_editor')));
      return /*#__PURE__*/_react.default.createElement(DataControlEditor, {
        ariaLabelledBy: "control-editor-title-input",
        controlGroupApi: controlGroupApi,
        initialState: initialState,
        controlType: controlType,
        controlId: controlId,
        initialDefaultPanelTitle: initialDefaultPanelTitle,
        onCancel: state => {
          onCancel(state, closeFlyout);
        },
        onSave: (state, selectedControlType) => {
          closeFlyout();
          onSave({
            type: selectedControlType,
            state
          });
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 9
        }
      });
    },
    flyoutProps: {
      triggerId: 'dashboard-controls-menu-button'
    }
  });
};
exports.openDataControlEditor = openDataControlEditor;