"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERROR_STATE_TEST_SUBJECT = exports.EMPTY_SCORE_TEST_SUBJECT = exports.EMPTY_EVALUATION_TEST_SUBJECT = exports.BenchmarksTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _constants = require("../../common/constants");
var TEST_SUBJ = _interopRequireWildcard(require("./test_subjects"));
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _full_size_centered_page = require("../../components/full_size_centered_page");
var _compliance_score_bar = require("../../components/compliance_score_bar");
var _helpers = require("../../../common/utils/helpers");
var _cis_benchmark_icon = require("../../components/cis_benchmark_icon");
var _use_benchmark_dynamic_values = require("../../common/hooks/use_benchmark_dynamic_values");
var _use_kibana = require("../../common/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/benchmarks/benchmarks_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ERROR_STATE_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = 'benchmark_page_error';
const EMPTY_EVALUATION_TEST_SUBJECT = exports.EMPTY_EVALUATION_TEST_SUBJECT = 'benchmark-not-evaluated-account';
const EMPTY_SCORE_TEST_SUBJECT = exports.EMPTY_SCORE_TEST_SUBJECT = 'benchmark-score-no-findings';
const BenchmarkButtonLink = ({
  benchmarkId,
  benchmarkVersion
}) => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: application === null || application === void 0 ? void 0 : application.getUrlForApp('security', {
      path: (0, _reactRouterDom.generatePath)(_cloudSecurityPosture.benchmarksNavigation.rules.path, {
        benchmarkVersion,
        benchmarkId
      })
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, (0, _helpers.getBenchmarkCisName)(benchmarkId));
};
const ErrorMessageComponent = error => /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  color: "danger",
  iconType: "warning",
  "data-test-subj": ERROR_STATE_TEST_SUBJECT,
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.benchmarks.benchmarksTable.errorRenderer.errorTitle",
    defaultMessage: "We couldn't fetch your cloud security posture benchmark data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })),
  body: (0, _cloud_posture_page.isCommonError)(error) ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.benchmarks.benchmarksTable.errorRenderer.errorDescription",
    defaultMessage: "{error} {statusCode}: {body}",
    values: {
      error: error.body.error,
      statusCode: error.body.statusCode,
      body: error.body.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  })) : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 5
  }
}));
const getBenchmarkTableColumns = (getBenchmarkDynamicValues, navToFindings) => [{
  field: 'id',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.integrationBenchmarkCisName', {
    defaultMessage: 'Benchmark'
  }),
  truncateText: true,
  width: '17.5%',
  sortable: true,
  render: (benchmarkId, benchmark) => /*#__PURE__*/_react.default.createElement(BenchmarkButtonLink, {
    benchmarkId: benchmarkId || '',
    benchmarkVersion: benchmark.version || '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }),
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.CIS_NAME
}, {
  field: 'version',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.integrationBenchmarkVersion', {
    defaultMessage: 'Version'
  }),
  truncateText: true,
  sortable: true,
  width: '17.5%',
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.VERSION
}, {
  field: 'id',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.applicableTo', {
    defaultMessage: 'Applicable To'
  }),
  truncateText: true,
  width: '30%',
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.APPLICABLE_TO,
  render: benchmarkId => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
      type: benchmarkId,
      size: 'l',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }, (0, _helpers.getBenchmarkApplicableTo)(benchmarkId)));
  }
}, {
  field: 'evaluation',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.evaluated', {
    defaultMessage: 'Evaluated'
  }),
  dataType: 'string',
  truncateText: true,
  width: '17.5%',
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.EVALUATED,
  render: (benchmarkEvaluation, benchmark) => {
    const {
      resourceCountLabel,
      integrationLink
    } = getBenchmarkDynamicValues(benchmark.id, benchmarkEvaluation);
    if (benchmarkEvaluation === 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": EMPTY_EVALUATION_TEST_SUBJECT,
        href: integrationLink,
        iconType: "plusInCircle",
        flush: "left",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.addIntegrationTitle', {
        defaultMessage: 'Add {resourceCountLabel}',
        values: {
          resourceCountLabel
        }
      }));
    }
    const isKspmBenchmark = ['cis_k8s', 'cis_eks'].includes(benchmark.id);
    const groupByField = isKspmBenchmark ? _constants.FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_ID : _constants.FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_ID;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      onClick: () => {
        navToFindings({
          'rule.benchmark.id': benchmark.id
        }, [groupByField]);
      },
      "aria-label": _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.evaluatedAriaLabel', {
        defaultMessage: 'CIS Benchmark {benchmarkId} version {benchmarkVersion} evaluated with {resourceCountLabel} ',
        values: {
          benchmarkId: benchmark.id,
          benchmarkVersion: benchmark.version || 'N/A',
          resourceCountLabel
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.accountsCountTitle', {
      defaultMessage: '{benchmarkEvaluation} {resourceCountLabel}',
      values: {
        benchmarkEvaluation,
        resourceCountLabel
      }
    }));
  }
}, {
  field: 'score',
  name: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksTable.score', {
    defaultMessage: 'Compliance'
  }),
  dataType: 'string',
  truncateText: true,
  width: '7.5%',
  'data-test-subj': TEST_SUBJ.BENCHMARKS_TABLE_COLUMNS.COMPLIANCE,
  render: data => {
    if (data.totalFindings > 0) return /*#__PURE__*/_react.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
      totalPassed: data === null || data === void 0 ? void 0 : data.totalPassed,
      totalFailed: data === null || data === void 0 ? void 0 : data.totalFailed,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 11
      }
    });
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": EMPTY_SCORE_TEST_SUBJECT,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.benchmarks.benchmarksTable.noFindingsScore",
      defaultMessage: "No Findings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 11
      }
    }));
  }
}];
const BenchmarksTable = ({
  benchmarks,
  pageIndex,
  pageSize,
  totalItemCount,
  loading,
  error,
  setQuery,
  noItemsMessage,
  sorting,
  ...rest
}) => {
  const {
    getBenchmarkDynamicValues
  } = (0, _use_benchmark_dynamic_values.useBenchmarkDynamicValues)();
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const pagination = {
    pageIndex: Math.max(pageIndex - 1, 0),
    pageSize,
    totalItemCount
  };
  const benchmarksSorted = (0, _react.useMemo)(() => {
    return [...benchmarks].sort((benchmarkDataA, benchmarkDataB) => benchmarkDataA.id.localeCompare(benchmarkDataB.id));
  }, [benchmarks]);
  const onChange = ({
    page
  }) => {
    setQuery({
      page: {
        ...page,
        index: page.index + 1
      }
    });
  };
  if (error) {
    return /*#__PURE__*/_react.default.createElement(ErrorMessageComponent, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": rest['data-test-subj'],
    items: benchmarksSorted,
    columns: getBenchmarkTableColumns(getBenchmarkDynamicValues, navToFindings),
    itemId: item => [item.id, item.version].join('/'),
    pagination: pagination,
    onChange: onChange,
    tableLayout: "fixed",
    loading: loading,
    noItemsMessage: noItemsMessage,
    error: error
    /* Disabled Sorting until we have the final Benchmark table */
    // sorting={sorting}
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 5
    }
  });
};
exports.BenchmarksTable = BenchmarksTable;