"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/charts/public/static/components/legend_toggle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LegendToggleComponent = ({
  onClick,
  showLegend,
  legendPosition
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const baseStyles = (0, _react.useMemo)(() => (0, _react2.css)`
      position: absolute;
      bottom: 0;
      left: 0;
      z-index: 1;
      margin: ${euiTheme.size.xs};
    `, [euiTheme.size.xs]);
  const isOpenStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      background-color: ${euiTheme.colors.lightestShade};
    `, [euiTheme.colors.lightestShade]);
  const positionStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      left: auto;
      bottom: auto;
      right: 0;
      top: 0;
    `, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    type: "button",
    iconType: "list",
    color: "text",
    onClick: onClick,
    css: [baseStyles, showLegend ? isOpenStyle : null, ['left', 'bottom'].includes(legendPosition) ? positionStyle : null],
    "aria-label": _i18n.i18n.translate('charts.legend.toggleLegendButtonAriaLabel', {
      defaultMessage: 'Toggle legend'
    }),
    "aria-expanded": showLegend,
    isSelected: showLegend,
    "data-test-subj": "vislibToggleLegend",
    title: _i18n.i18n.translate('charts.legend.toggleLegendButtonTitle', {
      defaultMessage: 'Toggle legend'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  });
};
const LegendToggle = exports.LegendToggle = /*#__PURE__*/(0, _react.memo)(LegendToggleComponent);