"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservablesUserActionBuilder = void 0;
var _domain = require("../../../../common/types/domain");
var _constants = require("../../../../common/constants");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservablesUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    const {
      caseId
    } = args;
    const action = _domain.UserActionActions.create;
    const parameters = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'observables',
      value: args.payload.observables,
      type: _domain.UserActionTypes.observables
    });
    const getMessage = id => `User added observables to case id: ${caseId} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: 'case_user_action_observables',
      savedObjectId: caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.ObservablesUserActionBuilder = ObservablesUserActionBuilder;