"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Workpad = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _transitions_registry = require("../../lib/transitions_registry");
var _elements = require("../../state/actions/elements");
var _transient = require("../../state/actions/transient");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _app_handler_creators = require("../../lib/app_handler_creators");
var _ui_metric = require("../../lib/ui_metric");
var _constants = require("../../../common/lib/constants");
var _workpad2 = require("../../routes/workpad");
var _workpad3 = require("./workpad.component");
var _hooks = require("../hooks");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad/workpad.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
// @ts-expect-error
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Workpad = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [grid, setGrid] = (0, _react.useState)(false);
  const [transition, setTransition] = (0, _react.useState)(null);
  const [prevSelectedPageNumber] = (0, _react.useState)(0);
  const {
    isFullscreen,
    setFullscreen,
    undo,
    redo,
    autoplayInterval,
    nextPage,
    previousPage
  } = (0, _react.useContext)(_workpad2.WorkpadRoutingContext);
  const hasHeaderBanner = (0, _useObservable.default)(_kibana_services.coreServices.chrome.hasHeaderBanner$());
  const propsFromState = (0, _reactRedux.useSelector)(state => {
    const {
      width,
      height,
      id: workpadId,
      css: workpadCss
    } = (0, _workpad.getWorkpad)(state);
    return {
      pages: (0, _workpad.getPages)(state),
      selectedPageNumber: (0, _workpad.getSelectedPageIndex)(state) + 1,
      totalElementCount: (0, _workpad.getAllElements)(state).length,
      width,
      height,
      workpadCss,
      workpadId,
      isFullscreen: (0, _app.getFullscreen)(state),
      zoomScale: (0, _app.getZoomScale)(state)
    };
  });
  const selectedPage = propsFromState.pages[propsFromState.selectedPageNumber - 1];
  (0, _hooks.useIncomingEmbeddable)(selectedPage);
  const fetchAllRenderables = (0, _react.useCallback)(() => {
    dispatch((0, _elements.fetchAllRenderables)());
  }, [dispatch]);
  const setZoomScale = (0, _react.useCallback)(scale => {
    dispatch((0, _transient.setZoomScale)(scale));
  }, [dispatch]);
  const getAnimation = (0, _react.useCallback)(pageNumber => {
    if (!transition || !transition.name) {
      return null;
    }
    if (![propsFromState.selectedPageNumber, prevSelectedPageNumber].includes(pageNumber)) {
      return null;
    }
    const {
      enter,
      exit
    } = _transitions_registry.transitionsRegistry.get(transition.name);
    const laterPageNumber = Math.max(propsFromState.selectedPageNumber, prevSelectedPageNumber);
    const name = pageNumber === laterPageNumber ? enter : exit;
    const direction = prevSelectedPageNumber > propsFromState.selectedPageNumber ? 'reverse' : 'normal';
    return {
      name,
      direction
    };
  }, [propsFromState.selectedPageNumber, transition, prevSelectedPageNumber]);
  const onTransitionEnd = (0, _react.useCallback)(() => setTransition(null), [setTransition]);
  const setFullscreenWithEffect = (0, _react.useCallback)(fullscreen => {
    setFullscreen(fullscreen);
    if (fullscreen === true) {
      (0, _ui_metric.trackCanvasUiMetric)(_ui_metric.METRIC_TYPE.COUNT, autoplayInterval > 0 ? [_constants.LAUNCHED_FULLSCREEN, _constants.LAUNCHED_FULLSCREEN_AUTOPLAY] : _constants.LAUNCHED_FULLSCREEN);
    }
  }, [setFullscreen, autoplayInterval]);
  const zoomHandlers = (0, _app_handler_creators.useZoomHandlers)({
    setZoomScale,
    zoomScale: propsFromState.zoomScale
  });
  return /*#__PURE__*/_react.default.createElement(_workpad3.Workpad, (0, _extends2.default)({}, props, propsFromState, {
    setFullscreen: setFullscreenWithEffect,
    isFullscreen: isFullscreen,
    undoHistory: undo,
    redoHistory: redo,
    hasHeaderBanner: hasHeaderBanner,
    grid: grid,
    setGrid: setGrid,
    nextPage: nextPage,
    previousPage: previousPage,
    fetchAllRenderables: fetchAllRenderables,
    getAnimation: getAnimation,
    onTransitionEnd: onTransitionEnd
  }, zoomHandlers, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }));
};
exports.Workpad = Workpad;