"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEmbeddableFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/saved-objects-finder-plugin/public");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/embeddable_flyout/flyout.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getNoItemsText: () => _i18n.i18n.translate('xpack.canvas.embedObject.noMatchingObjectsMessage', {
    defaultMessage: 'No matching objects found.'
  }),
  getTitleText: () => _i18n.i18n.translate('xpack.canvas.embedObject.titleText', {
    defaultMessage: 'Add from library'
  })
};
const AddEmbeddableFlyout = ({
  onSelect,
  availableEmbeddables,
  onClose,
  isByValueEnabled
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const libraryTypes = (0, _public.useAddFromLibraryTypes)();
  const canvasOnlyLibraryTypes = (0, _react.useMemo)(() => {
    // Links panels are not supported in Canvas
    return libraryTypes.filter(({
      type
    }) => type !== 'links');
  }, [libraryTypes]);
  const onAddPanel = (0, _react.useCallback)((id, savedObjectType) => {
    onSelect(id, savedObjectType, isByValueEnabled);
  }, [isByValueEnabled, onSelect]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "dashboardAddPanel",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, strings.getTitleText()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.SavedObjectFinder, {
    id: "canvasEmbeddableFlyout",
    onChoose: onAddPanel,
    savedObjectMetaData: canvasOnlyLibraryTypes,
    showFilter: true,
    noItemsMessage: strings.getNoItemsText(),
    services: {
      contentClient: _kibana_services.contentManagementService.client,
      uiSettings: _kibana_services.coreServices.uiSettings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })));
};
exports.AddEmbeddableFlyout = AddEmbeddableFlyout;