"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _assets = require("../../state/selectors/assets");
var _workpad = require("../../state/selectors/workpad");
var _arg_form = require("./arg_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getLabel = (label, argTypeInstance) => label || argTypeInstance.displayName || argTypeInstance.name;
const ArgForm = props => {
  const {
    argTypeInstance,
    label: labelFromProps,
    templateProps
  } = props;
  const [label, setLabel] = (0, _react.useState)(getLabel(labelFromProps, argTypeInstance));
  const [resolvedArgValue, setResolvedArgValue] = (0, _react.useState)(null);
  const workpad = (0, _reactRedux.useSelector)(_workpad.getWorkpadInfo);
  const assets = (0, _reactRedux.useSelector)(_assets.getAssets);
  (0, _react.useEffect)(() => {
    setResolvedArgValue();
  }, [templateProps === null || templateProps === void 0 ? void 0 : templateProps.argValue]);
  return /*#__PURE__*/_react.default.createElement(_arg_form.ArgForm, (0, _extends2.default)({}, props, {
    workpad: workpad,
    assets: assets,
    label: label,
    setLabel: setLabel,
    resolvedArgValue: resolvedArgValue,
    setResolvedArgValue: setResolvedArgValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }));
};
exports.ArgForm = ArgForm;
ArgForm.propTypes = {
  label: _propTypes.default.string,
  argTypeInstance: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    displayName: _propTypes.default.string,
    expanded: _propTypes.default.bool
  }).isRequired
};