"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("@kbn/elastic-assistant/impl/tour/elastic_llm/translations");
var _helpers = require("@kbn/elastic-assistant/impl/connectorland/helpers");
var _authorization = require("../../../../../common/components/authorization");
var _use_authorization = require("../../../../../common/hooks/use_authorization");
var _use_kibana = require("../../../../../common/hooks/use_kibana");
var _step_content_wrapper = require("../step_content_wrapper");
var _connector_selector = require("./connector_selector");
var _connector_setup = require("./connector_setup");
var _state = require("../../state");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/connector_step/connector_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * List of allowed action type IDs for the integrations assistant.
 */
const AllowedActionTypeIds = ['.bedrock', '.gen-ai', '.gemini'];
const ElasticLLMNewIntegrationMessage = /*#__PURE__*/_react.default.memo(() => {
  const {
    docLinks: {
      links: {
        securitySolution: {
          thirdPartyLlmProviders: THIRD_PARTY_LLM_LINK,
          llmPerformanceMatrix: LLM_PERFORMANCE_LINK
        },
        observability: {
          elasticManagedLlmUsageCost: ELASTIC_LLM_USAGE_COST_LINK
        }
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.steps.connector.esLLM.supportedModelsInfo",
    defaultMessage: "The Elastic Managed LLM connector is selected by default. Review its {usageCost} or {thirdParty}. Model {performance} varies by task.",
    values: {
      usageCost: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ELASTIC_LLM_USAGE_COST_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }, _translations.ELASTIC_LLM_USAGE_COSTS),
      thirdParty: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: THIRD_PARTY_LLM_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      }, _translations.ELASTIC_LLM_THIRD_PARTY),
      performance: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: LLM_PERFORMANCE_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 11
        }
      }, _translations.ELASTIC_LLM_TOUR_PERFORMANCE)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
});
ElasticLLMNewIntegrationMessage.displayName = 'ElasticLLMNewIntegrationMessage';
const ConnectorStep = exports.ConnectorStep = /*#__PURE__*/_react.default.memo(({
  connector
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http,
    notifications,
    triggersActionsUi,
    settings
  } = (0, _use_kibana.useKibana)().services;
  const {
    setConnector,
    completeStep
  } = (0, _state.useActions)();
  const [connectors, setConnectors] = (0, _react.useState)();
  let inferenceEnabled = false;
  if (triggersActionsUi.actionTypeRegistry.has('.inference')) {
    inferenceEnabled = triggersActionsUi.actionTypeRegistry.get('.inference');
  }
  if (inferenceEnabled) {
    AllowedActionTypeIds.push('.inference');
  }
  const {
    isLoading,
    data: aiConnectors,
    refetch: refetchConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    toasts: notifications.toasts,
    inferenceEnabled,
    settings
  });
  (0, _react.useEffect)(() => {
    if (aiConnectors != null) {
      // filter out connectors, this is temporary until we add support for more models
      const filteredAiConnectors = aiConnectors.filter(({
        actionTypeId
      }) => AllowedActionTypeIds.includes(actionTypeId));
      setConnectors(filteredAiConnectors);
      if (filteredAiConnectors && filteredAiConnectors.length === 1) {
        // pre-select the connector if there is only one
        setConnector(filteredAiConnectors[0]);
      }
    }
  }, [aiConnectors, setConnector]);
  const onConnectorSaved = (0, _react.useCallback)(() => refetchConnectors(), [refetchConnectors]);
  const hasConnectors = !isLoading && (connectors === null || connectors === void 0 ? void 0 : connectors.length);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: e => {
      e.preventDefault();
      completeStep();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.TITLE,
    subtitle: i18n.DESCRIPTION,
    right: hasConnectors ? /*#__PURE__*/_react.default.createElement(CreateConnectorPopover, {
      onConnectorSaved: onConnectorSaved,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 27
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasConnectors ? /*#__PURE__*/_react.default.createElement(_connector_selector.ConnectorSelector, {
    connectors: connectors,
    setConnector: setConnector,
    selectedConnectorId: connector === null || connector === void 0 ? void 0 : connector.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_authorization.AuthorizationWrapper, {
    canCreateConnectors: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_setup.ConnectorSetup, {
    actionTypeIds: AllowedActionTypeIds,
    onConnectorSaved: onConnectorSaved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      margin: euiTheme.size.xxs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    size: "s",
    className: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }, inferenceEnabled && (0, _helpers.isElasticManagedLlmConnector)(connector) ? /*#__PURE__*/_react.default.createElement(ElasticLLMNewIntegrationMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 17
    }
  }) : i18n.SUPPORTED_MODELS_INFO)))));
});
ConnectorStep.displayName = 'ConnectorStep';
const CreateConnectorPopover = /*#__PURE__*/_react.default.memo(({
  onConnectorSaved
}) => {
  const {
    canCreateConnectors
  } = (0, _use_authorization.useAuthorization)();
  const [isOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const openPopover = (0, _react.useCallback)(() => setIsPopoverOpen(true), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onConnectorSavedAndClose = (0, _react.useCallback)(() => {
    onConnectorSaved();
    closePopover();
  }, [onConnectorSaved, closePopover]);
  if (!canCreateConnectors) {
    return /*#__PURE__*/_react.default.createElement(_authorization.MissingPrivilegesTooltip, {
      canCreateConnectors: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "createConnectorPopoverButtonDisabled",
      disabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 9
      }
    }, i18n.CREATE_CONNECTOR));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "createConnectorPopoverButton",
      onClick: openPopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 11
      }
    }, i18n.CREATE_CONNECTOR)),
    isOpen: isOpen,
    closePopover: closePopover,
    "data-test-subj": "createConnectorPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_setup.ConnectorSetup, {
    actionTypeIds: AllowedActionTypeIds,
    onConnectorSaved: onConnectorSavedAndClose,
    onClose: closePopover,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }));
});
CreateConnectorPopover.displayName = 'CreateConnectorPopover';