"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOrTransactionsOverviewLink = ServiceOrTransactionsOverviewLink;
exports.useServiceOrTransactionsOverviewHref = useServiceOrTransactionsOverviewHref;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _apm_link_hooks = require("./apm_link_hooks");
var _helpers = require("../../../../context/url_params_context/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/apm/service_transactions_overview_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const persistedFilters = ['transactionResult', 'host', 'containerId', 'podName', 'serviceVersion', 'latencyAggregationType'];
function useServiceOrTransactionsOverviewHref({
  serviceName,
  environment,
  transactionType
}) {
  const query = {
    environment,
    transactionType
  };
  return (0, _apm_link_hooks.useAPMHref)({
    path: '/services/{serviceName}',
    pathParams: {
      serviceName
    },
    persistedFilters,
    query: (0, _helpers.removeUndefinedProps)(query)
  });
}
function ServiceOrTransactionsOverviewLink({
  serviceName,
  environment,
  transactionType,
  ...rest
}) {
  const href = useServiceOrTransactionsOverviewHref({
    serviceName,
    environment,
    transactionType
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmServiceOrTransactionsOverviewLinkLink",
    href: href
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }));
}