"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentExplorer = AgentExplorer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _agent_name = require("../../../../../common/agent_name");
var _apm = require("../../../../../common/es_fields/apm");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _environments_context = require("../../../../context/environments_context/environments_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_progressive_fetcher = require("../../../../hooks/use_progressive_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _environment_filter = require("../../../shared/environment_filter");
var _unified_search_bar = require("../../../shared/unified_search_bar");
var urlHelpers = _interopRequireWildcard(require("../../../shared/links/url_helpers"));
var _suggestions_select = require("../../../shared/suggestions_select");
var _agent_list = require("./agent_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_explorer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOtelLatestAgentVersion = (agentTelemetryAutoVersion, otelLatestVersion) => {
  return agentTelemetryAutoVersion.length > 0 ? otelLatestVersion === null || otelLatestVersion === void 0 ? void 0 : otelLatestVersion.auto_latest_version : otelLatestVersion === null || otelLatestVersion === void 0 ? void 0 : otelLatestVersion.sdk_latest_version;
};
function useAgentExplorerFetcher({
  start,
  end
}) {
  const {
    query: {
      environment,
      serviceName,
      agentLanguage,
      kuery
    }
  } = (0, _use_apm_params.useApmParams)('/settings/agent-explorer');
  return (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/get_agents_per_service', {
      params: {
        query: {
          environment,
          serviceName,
          agentLanguage,
          kuery,
          start,
          end
        }
      }
    });
  }, [environment, serviceName, agentLanguage, kuery, start, end]);
}
function useLatestAgentVersionsFetcher(latestAgentVersionEnabled) {
  return (0, _use_fetcher.useFetcher)(callApmApi => {
    if (latestAgentVersionEnabled) {
      return callApmApi('GET /internal/apm/get_latest_agent_versions');
    }
  }, [latestAgentVersionEnabled]);
}
function AgentExplorer() {
  var _agents$data$items, _agents$data;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    query: {
      serviceName,
      agentLanguage
    }
  } = (0, _use_apm_params.useApmParams)('/settings/agent-explorer');
  const rangeFrom = 'now-24h';
  const rangeTo = 'now';
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const latestAgentVersionEnabled = !(0, _lodash.isEmpty)(config.latestAgentVersionsUrl);
  const agents = useAgentExplorerFetcher({
    start,
    end
  });
  const {
    data: latestAgentVersions,
    status: latestAgentVersionsStatus
  } = useLatestAgentVersionsFetcher(latestAgentVersionEnabled);
  const isLoading = agents.status === _use_fetcher.FETCH_STATUS.LOADING;
  const isLatestAgentVersionsLoading = latestAgentVersionsStatus === _use_fetcher.FETCH_STATUS.LOADING;
  const agentItems = ((_agents$data$items = (_agents$data = agents.data) === null || _agents$data === void 0 ? void 0 : _agents$data.items) !== null && _agents$data$items !== void 0 ? _agents$data$items : []).map(agent => {
    var _latestAgentVersions$, _latestAgentVersions$2, _latestAgentVersions$3;
    return {
      ...agent,
      latestVersion: (0, _agent_name.isOpenTelemetryAgentName)(agent.agentName) ? getOtelLatestAgentVersion(agent.agentTelemetryAutoVersion, latestAgentVersions === null || latestAgentVersions === void 0 ? void 0 : (_latestAgentVersions$ = latestAgentVersions.data) === null || _latestAgentVersions$ === void 0 ? void 0 : _latestAgentVersions$[agent.agentName]) : latestAgentVersions === null || latestAgentVersions === void 0 ? void 0 : (_latestAgentVersions$2 = latestAgentVersions.data) === null || _latestAgentVersions$2 === void 0 ? void 0 : (_latestAgentVersions$3 = _latestAgentVersions$2[agent.agentName]) === null || _latestAgentVersions$3 === void 0 ? void 0 : _latestAgentVersions$3.latest_version
    };
  });
  const noItemsMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.agentExplorer.notFoundLabel', {
      defaultMessage: 'No Agents found'
    })),
    titleSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.settings.agentExplorer.title', {
    defaultMessage: 'Agent explorer'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.agentExplorer.descriptionText', {
    defaultMessage: 'Agent Explorer provides an inventory and details of deployed APM agents. EDOT SDKs are not currently listed.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    showDatePicker: false,
    showSubmitButton: false,
    isClearable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_environments_context.EnvironmentsContextProvider, {
    customTimeRange: {
      rangeFrom,
      rangeTo
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_environment_filter.ApmEnvironmentFilter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    prepend: _i18n.i18n.translate('xpack.apm.agentExplorer.serviceNameSelect.label', {
      defaultMessage: 'Service name'
    }),
    defaultValue: serviceName,
    fieldName: _apm.SERVICE_NAME,
    onChange: value => {
      urlHelpers.push(history, {
        query: {
          serviceName: value !== null && value !== void 0 ? value : ''
        }
      });
    },
    placeholder: _i18n.i18n.translate('xpack.apm.agentExplorer.serviceNameSelect.placeholder', {
      defaultMessage: 'All'
    }),
    start: start,
    end: end,
    dataTestSubj: "agentExplorerServiceNameSelect",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    prepend: _i18n.i18n.translate('xpack.apm.agentExplorer.agentLanguageSelect.label', {
      defaultMessage: 'Agent language'
    }),
    defaultValue: agentLanguage,
    fieldName: _apm.SERVICE_LANGUAGE_NAME,
    onChange: value => {
      urlHelpers.push(history, {
        query: {
          agentLanguage: value !== null && value !== void 0 ? value : ''
        }
      });
    },
    placeholder: _i18n.i18n.translate('xpack.apm.agentExplorer.agentLanguageSelect.placeholder', {
      defaultMessage: 'All'
    }),
    start: start,
    end: end,
    dataTestSubj: "agentExplorerAgentLanguageSelect",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.apm.agentExplorer.callout.24hoursData', {
      defaultMessage: 'Information based on the last 24h'
    }),
    iconType: "clock",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_list.AgentList, {
    isLoading: isLoading,
    items: agentItems,
    noItemsMessage: noItemsMessage,
    isLatestVersionsLoading: isLatestAgentVersionsLoading,
    latestVersionsFailed: !!(latestAgentVersions !== null && latestAgentVersions !== void 0 && latestAgentVersions.error),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  })));
}