"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceCorrelationAnalysis = TraceCorrelationAnalysis;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763035465751640924/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/diagnostic_tool/trace_correlation_analysis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TraceCorrelationAnalysis({
  traceCorrelation,
  traceId,
  sourceNode,
  destinationNode
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!traceId || !traceCorrelation) {
    return null;
  }
  const {
    found,
    foundInSourceNode,
    foundInDestinationNode,
    sourceNodeDocumentCount,
    destinationNodeDocumentCount
  } = traceCorrelation;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.title', {
    defaultMessage: 'Trace Correlation Analysis'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), found ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.success', {
    defaultMessage: 'Trace found in both {sourceNode} and {destinationNode}',
    values: {
      sourceNode,
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }, sourceNodeDocumentCount + destinationNodeDocumentCount, ' ', _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: 'documents'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.successDetails', {
    defaultMessage: 'The trace was successfully found in both services: {sourceCount, plural, one {# document} other {# documents}} in {sourceNode} and {destinationCount, plural, one {# document} other {# documents}} in {destinationNode}. This indicates proper trace correlation between the services.',
    values: {
      sourceCount: sourceNodeDocumentCount,
      sourceNode,
      destinationCount: destinationNodeDocumentCount,
      destinationNode
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.notFound', {
    defaultMessage: 'Trace correlation issue detected'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: '{count, plural, one {# document} other {# documents}}',
    values: {
      count: sourceNodeDocumentCount + destinationNodeDocumentCount
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.notFoundDescription', {
    defaultMessage: 'Trace ID {traceId} was not found in both services during the selected time range. Found {sourceCount, plural, one {# document} other {# documents}} in {sourceNode} and {destinationCount, plural, one {# document} other {# documents}} in {destinationNode}. This could indicate:',
    values: {
      traceId,
      sourceCount: sourceNodeDocumentCount,
      sourceNode,
      destinationCount: destinationNodeDocumentCount,
      destinationNode
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      marginTop: euiTheme.size.s,
      paddingLeft: euiTheme.size.base
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, !foundInSourceNode && /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.missingInSource', {
    defaultMessage: 'Trace not found in source service ({sourceNode})',
    values: {
      sourceNode
    }
  })), !foundInDestinationNode && /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.missingInDestination', {
    defaultMessage: 'Trace not found in destination service ({destinationNode})',
    values: {
      destinationNode
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.timeRangeIssue', {
    defaultMessage: 'The trace may have occurred outside the selected time range'
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.instrumentationIssue', {
    defaultMessage: 'Missing or incomplete distributed tracing instrumentation'
  }))))));
}