/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ExponentialHistogramArrayBlock;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CompressedExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;
import org.elasticsearch.index.mapper.BlockLoader;

public class ExponentialHistogramBlockBuilder
implements Block.Builder,
BlockLoader.ExponentialHistogramBuilder {
    private final DoubleBlock.Builder minimaBuilder;
    private final DoubleBlock.Builder maximaBuilder;
    private final DoubleBlock.Builder sumsBuilder;
    private final LongBlock.Builder valueCountsBuilder;
    private final DoubleBlock.Builder zeroThresholdsBuilder;
    private final BytesRefBlock.Builder encodedHistogramsBuilder;
    private final BytesRef scratch = new BytesRef();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ExponentialHistogramBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        DoubleBlock.Builder minimaBuilder = null;
        DoubleBlock.Builder maximaBuilder = null;
        DoubleBlock.Builder sumsBuilder = null;
        LongBlock.Builder valueCountsBuilder = null;
        DoubleBlock.Builder zeroThresholdsBuilder = null;
        BytesRefBlock.Builder encodedHistogramsBuilder = null;
        boolean success = false;
        try {
            minimaBuilder = blockFactory.newDoubleBlockBuilder(estimatedSize);
            maximaBuilder = blockFactory.newDoubleBlockBuilder(estimatedSize);
            sumsBuilder = blockFactory.newDoubleBlockBuilder(estimatedSize);
            valueCountsBuilder = blockFactory.newLongBlockBuilder(estimatedSize);
            zeroThresholdsBuilder = blockFactory.newDoubleBlockBuilder(estimatedSize);
            encodedHistogramsBuilder = blockFactory.newBytesRefBlockBuilder(estimatedSize);
            this.minimaBuilder = minimaBuilder;
            this.maximaBuilder = maximaBuilder;
            this.sumsBuilder = sumsBuilder;
            this.valueCountsBuilder = valueCountsBuilder;
            this.zeroThresholdsBuilder = zeroThresholdsBuilder;
            this.encodedHistogramsBuilder = encodedHistogramsBuilder;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{minimaBuilder, maximaBuilder, sumsBuilder, valueCountsBuilder, zeroThresholdsBuilder, encodedHistogramsBuilder});
            throw throwable;
        }
    }

    public BlockLoader.DoubleBuilder minima() {
        return this.minimaBuilder;
    }

    public BlockLoader.DoubleBuilder maxima() {
        return this.maximaBuilder;
    }

    public BlockLoader.DoubleBuilder sums() {
        return this.sumsBuilder;
    }

    public BlockLoader.LongBuilder valueCounts() {
        return this.valueCountsBuilder;
    }

    public BlockLoader.DoubleBuilder zeroThresholds() {
        return this.zeroThresholdsBuilder;
    }

    public BlockLoader.BytesRefBuilder encodedHistograms() {
        return this.encodedHistogramsBuilder;
    }

    public ExponentialHistogramBlockBuilder append(ExponentialHistogram histogram) {
        assert (histogram != null);
        ZeroBucket zeroBucket = histogram.zeroBucket();
        BytesStreamOutput encodedBytes = new BytesStreamOutput();
        try {
            CompressedExponentialHistogram.writeHistogramBytes((OutputStream)encodedBytes, (int)histogram.scale(), (BucketIterator)histogram.negativeBuckets().iterator(), (BucketIterator)histogram.positiveBuckets().iterator());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode histogram", e);
        }
        if (Double.isNaN(histogram.min())) {
            this.minimaBuilder.appendNull();
        } else {
            this.minimaBuilder.appendDouble(histogram.min());
        }
        if (Double.isNaN(histogram.max())) {
            this.maximaBuilder.appendNull();
        } else {
            this.maximaBuilder.appendDouble(histogram.max());
        }
        this.sumsBuilder.appendDouble(histogram.sum());
        this.valueCountsBuilder.appendLong(histogram.valueCount());
        this.zeroThresholdsBuilder.appendDouble(zeroBucket.zeroThreshold());
        this.encodedHistogramsBuilder.appendBytesRef(encodedBytes.bytes().toBytesRef());
        return this;
    }

    public void deserializeAndAppend(ExponentialHistogramBlock.SerializedInput input) {
        long valueCount = input.readLong();
        this.valueCountsBuilder.appendLong(valueCount);
        this.sumsBuilder.appendDouble(input.readDouble());
        this.zeroThresholdsBuilder.appendDouble(input.readDouble());
        if (valueCount > 0L) {
            this.minimaBuilder.appendDouble(input.readDouble());
            this.maximaBuilder.appendDouble(input.readDouble());
        } else {
            this.minimaBuilder.appendNull();
            this.maximaBuilder.appendNull();
        }
        this.encodedHistogramsBuilder.appendBytesRef(input.readBytesRef(this.scratch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExponentialHistogramBlock build() {
        ExponentialHistogramArrayBlock exponentialHistogramArrayBlock;
        block3: {
            DoubleBlock minima = null;
            DoubleBlock maxima = null;
            DoubleBlock sums = null;
            LongBlock valueCounts = null;
            DoubleBlock zeroThresholds = null;
            BytesRefBlock encodedHistograms = null;
            boolean success = false;
            try {
                minima = this.minimaBuilder.build();
                maxima = this.maximaBuilder.build();
                sums = this.sumsBuilder.build();
                valueCounts = this.valueCountsBuilder.build();
                zeroThresholds = this.zeroThresholdsBuilder.build();
                encodedHistograms = this.encodedHistogramsBuilder.build();
                success = true;
                exponentialHistogramArrayBlock = new ExponentialHistogramArrayBlock(minima, maxima, sums, valueCounts, zeroThresholds, encodedHistograms);
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, zeroThresholds, encodedHistograms});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, zeroThresholds, encodedHistograms});
        }
        return exponentialHistogramArrayBlock;
    }

    @Override
    public ExponentialHistogramBlockBuilder appendNull() {
        this.minimaBuilder.appendNull();
        this.maximaBuilder.appendNull();
        this.sumsBuilder.appendNull();
        this.valueCountsBuilder.appendNull();
        this.zeroThresholdsBuilder.appendNull();
        this.encodedHistogramsBuilder.appendNull();
        return this;
    }

    @Override
    public ExponentialHistogramBlockBuilder beginPositionEntry() {
        throw new UnsupportedOperationException("ExponentialHistogramBlock does not support multi-values");
    }

    @Override
    public ExponentialHistogramBlockBuilder endPositionEntry() {
        throw new UnsupportedOperationException("ExponentialHistogramBlock does not support multi-values");
    }

    @Override
    public ExponentialHistogramBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int i = beginInclusive; i < endExclusive; ++i) {
                this.appendNull();
            }
        } else {
            ExponentialHistogramArrayBlock histoBlock = (ExponentialHistogramArrayBlock)block;
            histoBlock.copyInto(this.minimaBuilder, this.maximaBuilder, this.sumsBuilder, this.valueCountsBuilder, this.zeroThresholdsBuilder, this.encodedHistogramsBuilder, beginInclusive, endExclusive);
        }
        return this;
    }

    @Override
    public ExponentialHistogramBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        assert (mvOrdering == Block.MvOrdering.UNORDERED) : "Exponential histograms don't have a natural order, so it doesn't make sense to call this";
        return this;
    }

    @Override
    public long estimatedBytes() {
        return this.minimaBuilder.estimatedBytes() + this.maximaBuilder.estimatedBytes() + this.sumsBuilder.estimatedBytes() + this.valueCountsBuilder.estimatedBytes() + this.zeroThresholdsBuilder.estimatedBytes() + this.encodedHistogramsBuilder.estimatedBytes();
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.minimaBuilder, this.maximaBuilder, this.sumsBuilder, this.valueCountsBuilder, this.zeroThresholdsBuilder, this.encodedHistogramsBuilder});
    }
}

