/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final double percentile;

    public PercentileLongAggregatorFunctionSupplier(double percentile) {
        this.percentile = percentile;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return PercentileLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return PercentileLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public PercentileLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileLongAggregatorFunction.create(driverContext, channels, this.percentile);
    }

    @Override
    public PercentileLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileLongGroupingAggregatorFunction.create(channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of longs";
    }
}

